package com.biz.crm.common.log.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.log.local.entity.TmLogEntity;
import com.biz.crm.common.log.local.mapper.TmLogMapper;
import com.biz.crm.common.log.local.vo.TmLogVo;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Objects;
import java.util.Optional;


/**
 * 1.0业务日志
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2025/2/20 17:01
 */
@Component
public class TmLogRepository extends ServiceImpl<TmLogMapper, TmLogEntity> {

    public Page<TmLogVo> findByConditionsHistory(Pageable pageable, TmLogVo dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 30));
        dto = Optional.ofNullable(dto).orElse(new TmLogVo());
        Page<TmLogVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (Objects.nonNull(dto.getCreateDateEnd())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dto.getCreateDateEnd());
            calendar.add(Calendar.HOUR, 23);
            calendar.add(Calendar.MINUTE, 59);
            calendar.add(Calendar.SECOND, 59);
            dto.setCreateDateEnd(calendar.getTime());
        }
        return baseMapper.findByConditionsHistory(page, dto);
    }
}
