package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.log.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.*;

/**
 * @description: 业务日志工具类
 * @author: rentao
 * @date: 2022/5/10 11:43
 */
public class CrmBusinessLogUtil {

    public static List<CrmBusinessLogEsEntity> voToEntityForAdd(CrmBusinessLogDto crmBusinessLogDto) {
        List<CrmBusinessLogEsEntity> reList = null;
        Object newObject = crmBusinessLogDto.getNewObject();
        if (!(newObject instanceof Collection)) {
            reList = new ArrayList<>(1);
            CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
            reList.add(entity);
            return reList;
        } else {
            List<?> newObjects = (List<?>) newObject;
            reList = new ArrayList<>(newObjects.size());
            Iterator<?> iterator = newObjects.iterator();
            while (iterator.hasNext()) {
                CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
                reList.add(entity);
            }
            return reList;
        }
    }

    public static List<CrmBusinessLogEsEntity> voToEntityForDel(CrmBusinessLogDto crmBusinessLogDto) {
        List<CrmBusinessLogEsEntity> reList = null;
        Object oldObject = crmBusinessLogDto.getOldObject();
        if (!(oldObject instanceof Collection)) {
            reList = new ArrayList<>(1);
            CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
            reList.add(entity);
            return reList;
        } else {
            List<?> oldObjects = (List<?>) oldObject;
            reList = new ArrayList<>(oldObjects.size());
            Iterator<?> iterator = oldObjects.iterator();
            while (iterator.hasNext()) {
                CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
                reList.add(entity);
            }
            return reList;
        }
    }

    public static List<CrmBusinessLogEsEntity> voToEntityForEnableAndDisable(CrmBusinessLogDto crmBusinessLogDto, OperationTypeEunm operationTypeEunm) {
        List<CrmBusinessLogEsEntity> reList = null;
        Object oldObject = crmBusinessLogDto.getOldObject();
        if (!(oldObject instanceof Collection)) {
            reList = new ArrayList<>(1);
            CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
            reList.add(entity);
            return reList;
        } else {
            List<?> oldObjects = (List<?>) oldObject;
            reList = new ArrayList<>(oldObjects.size());
            Iterator<?> iterator = oldObjects.iterator();
            while (iterator.hasNext()) {
                CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
                reList.add(entity);
            }
            return reList;
        }
    }

    public static CrmBusinessLogEsEntity voToEntityForUpdate(CrmBusinessLogDto crmBusinessLogDto, Object result) {
        CrmBusinessLogEsEntity entity = newCommonFieldInstance(crmBusinessLogDto);
        entity.setCompareResult(JSON.toJSONString(result));
        return entity;
    }

    public static CrmBusinessLogEsEntity newCommonFieldInstance(CrmBusinessLogDto crmBusinessLogDto) {
        CrmBusinessLogEsEntity entity = new CrmBusinessLogEsEntity();
        entity.setId(UUID.randomUUID().toString().replace("-", ""));
        entity.setOnlyKey(crmBusinessLogDto.getOnlyKey());
        entity.setOperationType(crmBusinessLogDto.getOperationType());
        entity.setAppCode(crmBusinessLogDto.getAppCode());
        entity.setAppName(crmBusinessLogDto.getAppName());
        entity.setMenuCode(crmBusinessLogDto.getMenuCode());
        entity.setMenuName(crmBusinessLogDto.getMenuName());
        entity.setMenuAllName(crmBusinessLogDto.getMenuAllName());
        entity.setTenantCode(crmBusinessLogDto.getTenantCode());
        Date date = new Date();
        String format = DateFormatUtils.format(date, "yyyy-MM-dd HH:mm:ss");
        entity.setCreateTime(format);
        entity.setCreateName(crmBusinessLogDto.getCreateName());
        entity.setCreateAccount(crmBusinessLogDto.getCreateAccount());
        entity.setCreateTimeTimeNum(date.getTime());
        return entity;
    }
}
