package com.biz.crm.common.log.local.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 1.0日志vo类
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2025/2/20 16:45
 */
@Data
public class TmLogVo implements Serializable {

    private static final long serialVersionUID = 6619407943734943665L;
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("业务描述")
    private String businessDesc;

    @ApiModelProperty("操作类型;数据字典[operation_type]")
    private String operationType;

    @ApiModelProperty("日志内容")
    private String content;

    @ApiModelProperty("创建人")
    private String createName;

    @ApiModelProperty("创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty("创建时间开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDateBegin;

    @ApiModelProperty("创建时间结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDateEnd;

    @ApiModelProperty("业务ID")
    private String businessId;

    @ApiModelProperty("职位信息")
    private String positionName;

}
