package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;

import java.util.Map;

/**
 * @description: 日志对比工具类
 * @author: rentao
 * @date: 2022/5/10 11:51
 */
@Slf4j
public class LogCompare {

  /**
   * 字段对比
   *
   * @param oldJsonStr 修改前
   * @param newJsonStr 修改后
   * @author rentao
   * @date
   */
  public static Object compareObject(String oldJsonStr,
                                     String newJsonStr, Map<String,String> oldDateMap,Map<String,String> newDateMap) {
    JSONObject jsonOld = JSON.parseObject(oldJsonStr);
    oldDateMap.forEach((k,v)->{
      jsonOld.put(k,v);
    });
    JSONObject jsonNew = JSON.parseObject(newJsonStr);
    newDateMap.forEach((k,v)->{
      jsonNew.put(k,v);
    });
    return compareObjectNotBasicAndCollection(jsonOld,jsonNew);
  }

  /**
   * 对比对象合集合
   *
   * @param oldObject
   * @param newObject
   * @author rentao
   * @date
   */
  public static JSONObject compareObjectNotBasicAndCollection(JSONObject oldObject, JSONObject newObject) {
    Validate.notNull(oldObject, "日志需要对比的字段不存在");
    Validate.notNull(newObject, "日志需要对比的字段不存在");
    log.info("修改之前的字段:{}", oldObject);
    log.info("修改之后的字段:{}", newObject);
    JSONObject compare = OneCompare.compare(oldObject, newObject);
    return compare;
  }

}

