package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.log.local.repository.CrmBusinessLogEsRepository;
import com.biz.crm.common.log.local.utils.CrmBusinessLogUtil;
import com.biz.crm.common.log.local.utils.LogCompare;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.*;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 业务日志service
 * @author: rentao
 * @date: 2022/5/13 20:17
 */
@Service
@Slf4j
public class CrmBusinessLogVoServiceImpl implements CrmBusinessLogVoService {

  @Autowired(required = false)
  private CrmBusinessLogEsRepository crmBusinessLogRepository;
  @Autowired
  private LoginUserService loginUserService;

  private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");



  @Override
  @Transactional
  public void handleSave(CrmBusinessLogDto crmBusinessLogDto) {
    Validate.notNull(crmBusinessLogDto, "传入比对参数不存在！");
    Validate.notBlank(crmBusinessLogDto.getOperationType(), "记录业务日志时，操作类型不能为空！");
    Validate.notBlank(crmBusinessLogDto.getTenantCode(), "记录业务日志时，租户信息不能为空！");
    String operationType = crmBusinessLogDto.getOperationType();
    AbstractCrmUserIdentity context = loginUserService.getAbstractLoginUser();
    if (Objects.nonNull(context)) {
      crmBusinessLogDto.setCreateAccount(context.getAccount());
      crmBusinessLogDto.setCreateName(context.getRealName());
      if (OperationTypeEunm.CREATE.getDictCode().equals(operationType)) {
        this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForAdd(crmBusinessLogDto));
      } else if (OperationTypeEunm.DELETE.getDictCode().equals(operationType)) {
        this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForDel(crmBusinessLogDto));
      } else {
        //对date 字段格式化 并赋值
        Map<String,String> oldDateMap = this.transformDateFormat(crmBusinessLogDto.getOldObject());
        Map<String,String> newDateMap = this.transformDateFormat(crmBusinessLogDto.getNewObject());
        Object resullt = LogCompare
            .compareObject(JSON.toJSONString(crmBusinessLogDto.getOldObject(),
                SerializerFeature.WriteMapNullValue), JSON.toJSONString(crmBusinessLogDto.getNewObject(),SerializerFeature.WriteMapNullValue),oldDateMap,newDateMap);
        this.crmBusinessLogRepository.save(CrmBusinessLogUtil.voToEntityForUpdate(crmBusinessLogDto, resullt));
      }
    }
  }

  /**
   * 日期格式化
   *
   * */
  private Map<String,String> transformDateFormat(Object crmBusinessLogDto){
    Map<String,String> stringMap = new HashMap<>();
    List<Class<?>> classes = getAll(crmBusinessLogDto);
    for (Class<?> aClass : classes) {
      Field[] declaredFields = aClass.getDeclaredFields();
      for (int i = 0; i < declaredFields.length; i++) {
        Field declaredField = declaredFields[i];
        declaredField.setAccessible(true);
        if(declaredField.getType() == Date.class){
          try {
            String name = declaredField.getName();
            Object date = declaredField.get(crmBusinessLogDto);
            stringMap.put(name,dateFormat.format(date));
          } catch (Exception e) {
            log.info("格式化日期错误，跳过");
          }
        }
      }
    }
    return stringMap;
  }


  /**
   * 获取所有父类
   *
   * */
  public static List<Class<?>> getAll(Object o){
    Boolean s = true;
    List<Class<?>> classes = new ArrayList<>();
    classes.add(o.getClass());
    Class<?> superclass = o.getClass();
    while (s){
      superclass = superclass.getSuperclass();
      if(!superclass.getName().equals("java.lang.Object") && superclass != null){
        classes.add(superclass);
      }else {
        s = false;
      }
    }
    return classes;
  }

}
