package com.biz.crm.common.log.local.service.internal;

import com.biz.crm.common.log.local.service.CrmBusinessLogCommonService;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * @description: 业务日志service
 * @author: rentao
 * @date: 2022/5/13 20:17
 */
@Service
@Slf4j
public class CrmBusinessLogCommonServiceImpl<T> implements CrmBusinessLogCommonService {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    @SneakyThrows
    @Override
    @Async("logExecutor")
    public void onCreate(CrmBusinessLogDto logDto) {
        crmBusinessLogVoService.handleSave(logDto);
    }

    @SneakyThrows
    @Override
    @Async("logExecutor")
    public void onUpdate(CrmBusinessLogDto logDto) {
        crmBusinessLogVoService.handleSave(logDto);
    }

    @SneakyThrows
    @Override
    @Async("logExecutor")
    public void onDisable(CrmBusinessLogDto logDto) {
        crmBusinessLogVoService.handleSave(logDto);
    }

    @SneakyThrows
    @Override
    @Async("logExecutor")
    public void onEnable(CrmBusinessLogDto logDto) {
        crmBusinessLogVoService.handleSave(logDto);
    }

    @SneakyThrows
    @Override
    @Async("logExecutor")
    public void onDelete(CrmBusinessLogDto logDto) {
        crmBusinessLogVoService.handleSave(logDto);
    }

}
