package com.biz.crm.common.log.local.service;


import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;

/**
 * 日志服务接口
 *
 * @author huxmld
 */
public interface CrmBusinessLogCommonService {
    /**
     * 当创建时触发
     *
     * @param logDto 创建时的vo
     */
    void onCreate(CrmBusinessLogDto logDto);

    /**
     * 当修改时触发
     *
     * @param logDto
     */
    void onUpdate(CrmBusinessLogDto logDto);

    /**
     * 当禁用时触发
     *
     * @param logDto 禁用vo信息
     */
    void onDisable(CrmBusinessLogDto logDto);

    /**
     * 当启用时触发
     *
     * @param logDto 禁用vo信息
     */
    void onEnable(CrmBusinessLogDto logDto);

    /**
     * 当删除时触发
     *
     * @param logDto 删除vo信息
     */
    void onDelete(CrmBusinessLogDto logDto);

}
