/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.local.model.FieldTransformModel;
import com.biz.crm.common.log.sdk.vo.CrmBusinessLogEsVo;
import com.biz.crm.common.log.sdk.vo.DictDataTransformVo;
import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class LogTransform {
    public static String fieldTransform(CrmBusinessLogEsVo crmBusinessLogEsVo, FieldTransformModel transformModel) {
        String jsonStr = crmBusinessLogEsVo.getCompareResult();
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return jsonStr;
        }
        return LogTransform.oneTransform(crmBusinessLogEsVo, JSON.parseObject((String)jsonStr), transformModel).toString();
    }

    private static JSONObject oneTransform(CrmBusinessLogEsVo crmBusinessLogEsVo, JSONObject oldJsonObject, FieldTransformModel transformModel) {
        Map<String, FieldTransformVo> defaultFunctionFieldTransformMap = transformModel.getDefaultFunctionFieldTransformMap();
        Map<String, FieldTransformVo> functionFieldTransformMap = transformModel.getFunctionFieldTransformMap();
        Map<String, FieldTransformVo> defaultFieldTransformMap = transformModel.getDefaultFieldTransformMap();
        String parentCode = transformModel.getParentCode();
        JSONObject reJson = new JSONObject();
        for (String key : oldJsonObject.keySet()) {
            Object obj;
            FieldTransformVo fieldTransform = functionFieldTransformMap.get(String.format("%s-%s", parentCode, key));
            if (Objects.isNull(fieldTransform)) {
                fieldTransform = defaultFunctionFieldTransformMap.get(key);
            }
            if (Objects.isNull(fieldTransform)) {
                fieldTransform = defaultFieldTransformMap.get(key);
            }
            String fieldName = Objects.isNull(fieldTransform) ? key : fieldTransform.getFieldName();
            Object oldValue = oldJsonObject.get((Object)key);
            if (oldValue instanceof JSONObject) {
                obj = LogTransform.oneTransform(crmBusinessLogEsVo, (JSONObject)oldValue, transformModel);
                if (ObjectUtils.isEmpty((Object)obj)) continue;
                reJson.put(fieldName, obj);
                continue;
            }
            if (oldValue instanceof JSONArray) {
                try {
                    obj = LogTransform.manyTransform(crmBusinessLogEsVo, JSON.parseArray((String)JSON.toJSONString((Object)oldValue), JSONObject.class), transformModel);
                    if (CollectionUtils.isEmpty((Collection)obj)) continue;
                    reJson.put(fieldName, obj);
                }
                catch (Exception e) {
                    reJson.put(fieldName, oldValue);
                }
                continue;
            }
            if (oldValue instanceof String && Objects.nonNull(fieldTransform) && CollectionUtils.isNotEmpty((Collection)fieldTransform.getDictDataList())) {
                String[] splitValues = ((String)oldValue).replace("\u3011", "").replace("\u3010", "").split(" ---> ");
                String transValue = (String)oldValue;
                if (splitValues.length == 2) {
                    Map<String, String> dictMap = fieldTransform.getDictDataList().stream().collect(Collectors.toMap(DictDataTransformVo::getDictCode, DictDataTransformVo::getDictValue, (a, b) -> a));
                    transValue = String.format("\u3010%s  ---> %s\u3011", dictMap.getOrDefault(splitValues[0], splitValues[0]), dictMap.getOrDefault(splitValues[1], splitValues[1]));
                }
                reJson.put(fieldName, (Object)transValue);
                continue;
            }
            reJson.put(fieldName, oldValue);
        }
        return reJson;
    }

    private static List<JSONObject> manyTransform(CrmBusinessLogEsVo crmBusinessLogEsVo, List<JSONObject> oldJsonObjects, FieldTransformModel transformModel) {
        ArrayList<JSONObject> reList = new ArrayList<JSONObject>();
        ArrayList oldJsons = CollectionUtils.isEmpty(oldJsonObjects) ? new ArrayList() : oldJsonObjects;
        for (JSONObject jsonObject : oldJsons) {
            JSONObject result = LogTransform.oneTransform(crmBusinessLogEsVo, jsonObject, transformModel);
            if (result == null || result.isEmpty()) continue;
            reList.add(result);
        }
        return reList;
    }
}

