/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.log.local.entity.CrmBusinessLogEsEntity;
import com.biz.crm.common.log.local.model.FieldTransformModel;
import com.biz.crm.common.log.local.service.CrmBusinessLogService;
import com.biz.crm.common.log.local.utils.LogTransform;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogQueryDto;
import com.biz.crm.common.log.sdk.dto.FieldTransformDto;
import com.biz.crm.common.log.sdk.strategy.CrmBusinessLogStrategy;
import com.biz.crm.common.log.sdk.utils.EsUtil;
import com.biz.crm.common.log.sdk.vo.CrmBusinessLogEsVo;
import com.biz.crm.common.log.sdk.vo.FieldTransformVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrmBusinessLogServiceImpl
implements CrmBusinessLogService {
    @Autowired
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Autowired(required=false)
    private List<CrmBusinessLogStrategy> crmBusinessLogStrategyServices;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<CrmBusinessLogEsVo> findByConditions(Pageable pageable, CrmBusinessLogQueryDto crmBusinessLogDto) {
        crmBusinessLogDto = Optional.ofNullable(crmBusinessLogDto).orElse(new CrmBusinessLogQueryDto());
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        if (!EsUtil.indexExsitNoCreate((ElasticsearchRestTemplate)this.elasticsearchRestTemplate, CrmBusinessLogEsEntity.class)) {
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getOnlyKey())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"onlyKey", (String)crmBusinessLogDto.getOnlyKey()));
        }
        if (StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getAppCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"appCode", (String)TenantUtils.getTenantCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getSearchParentCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"parentCode", (String)crmBusinessLogDto.getSearchParentCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getTenantCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantCode", (String)TenantUtils.getTenantCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getOperationType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"operationType", (String)crmBusinessLogDto.getOperationType()));
        }
        if (StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getCreateAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createAccount", (String)crmBusinessLogDto.getCreateAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)crmBusinessLogDto.getCreateName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createName", (String)"*".concat(crmBusinessLogDto.getCreateName()).concat("*")));
        }
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"createTimeTimeNum").order(SortOrder.DESC)}).withPageable((Pageable)PageRequest.of((int)(pageable.getPageNumber() - 1), (int)pageable.getPageSize())).build();
        SearchHits searchs = this.elasticsearchRestTemplate.search((Query)searchQuery, CrmBusinessLogEsEntity.class);
        List crmLogEntityList = searchs.get().map(SearchHit::getContent).collect(Collectors.toList());
        ArrayList crmBusinessLogEsEntities = Lists.newArrayList();
        Page page = new Page();
        page.setTotal(searchs.getTotalHits());
        page.setCurrent((long)pageable.getPageNumber());
        if (CollectionUtils.isEmpty(crmLogEntityList)) {
            return page;
        }
        List crmBusinessLogEsVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(crmLogEntityList, CrmBusinessLogEsEntity.class, CrmBusinessLogEsVo.class, HashSet.class, ArrayList.class, new String[0]);
        crmBusinessLogEsEntities.addAll(this.handleFiledTransformation(crmBusinessLogEsVoList, crmBusinessLogDto));
        page.setRecords((List)crmBusinessLogEsEntities);
        return page;
    }

    private List<CrmBusinessLogEsVo> handleFiledTransformation(List<CrmBusinessLogEsVo> crmBusinessLogEsVos, CrmBusinessLogQueryDto dto) {
        if (CollectionUtils.isEmpty(this.crmBusinessLogStrategyServices)) {
            return crmBusinessLogEsVos;
        }
        Set<Object> parentCodes = Sets.newHashSet((Object[])new String[]{dto.getParentCode()});
        for (CrmBusinessLogEsVo crmBusinessLogEsVo : crmBusinessLogEsVos) {
            parentCodes.add(crmBusinessLogEsVo.getParentCode());
        }
        parentCodes = parentCodes.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        FieldTransformDto dataTransformDto = new FieldTransformDto();
        dataTransformDto.setParentCodes((Set)parentCodes);
        FieldTransformModel transformModel = new FieldTransformModel();
        ArrayList transformList = Lists.newArrayList();
        for (CrmBusinessLogStrategy crmBusinessLogStrategyService : this.crmBusinessLogStrategyServices) {
            transformList.addAll(crmBusinessLogStrategyService.handleTransformation(dataTransformDto));
        }
        transformModel.setDefaultFieldTransformMap(transformList.stream().filter(transformVo -> Boolean.TRUE.equals(transformVo.getIsDefault())).collect(Collectors.toMap(FieldTransformVo::getFieldCode, Function.identity(), (a, b) -> a)));
        transformModel.setFunctionFieldTransformMap(transformList.stream().filter(transformVo -> !Boolean.TRUE.equals(transformVo.getIsDefault())).collect(Collectors.toMap(transformVo -> String.format("%s-%s", transformVo.getParentCode(), transformVo.getFieldCode()), Function.identity(), (a, b) -> a)));
        if (StringUtils.isNotBlank((CharSequence)dto.getParentCode())) {
            transformModel.setDefaultFunctionFieldTransformMap(transformList.stream().filter(transformVo -> dto.getParentCode().equals(transformVo.getParentCode())).collect(Collectors.toMap(FieldTransformVo::getFieldCode, Function.identity(), (a, b) -> a)));
        }
        Map<String, String> parentNameMap = transformList.stream().filter(transformVo -> StringUtils.isNotBlank((CharSequence)transformVo.getParentCode()) && StringUtils.isNotBlank((CharSequence)transformVo.getParentName())).collect(Collectors.toMap(FieldTransformVo::getParentCode, FieldTransformVo::getParentName, (a, b) -> a));
        for (CrmBusinessLogEsVo crmBusinessLogEsVo : crmBusinessLogEsVos) {
            transformModel.setParentCode(crmBusinessLogEsVo.getParentCode());
            crmBusinessLogEsVo.setParentName(parentNameMap.get(crmBusinessLogEsVo.getParentCode()));
            String s = LogTransform.fieldTransform(crmBusinessLogEsVo, transformModel);
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            JSONObject jsonObject = JSON.parseObject((String)s);
            crmBusinessLogEsVo.setCompareResultJson(jsonObject);
        }
        return crmBusinessLogEsVos;
    }
}

