/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.log.local.repository.CrmBusinessLogEsRepository;
import com.biz.crm.common.log.local.utils.CrmBusinessLogUtil;
import com.biz.crm.common.log.local.utils.LogCompare;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.bizunited.nebula.common.util.SpringBeanUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.constant.Constants;
import com.bizunited.nebula.competence.sdk.service.CompetenceCacheVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class CrmBusinessLogVoServiceImpl
implements CrmBusinessLogVoService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessLogVoServiceImpl.class);
    @Autowired(required=false)
    private CrmBusinessLogEsRepository crmBusinessLogRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Value(value="${spring.application.name:}")
    private String appName;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Transactional
    public void handleSave(CrmBusinessLogDto crmBusinessLogDto) {
        Validate.notNull((Object)crmBusinessLogDto, (String)"\u4f20\u5165\u6bd4\u5bf9\u53c2\u6570\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)crmBusinessLogDto.getOnlyKey(), (String)"\u8bb0\u5f55\u4e1a\u52a1\u65e5\u5fd7\u65f6\uff0c\u4e1a\u52a1\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)crmBusinessLogDto.getOperationType(), (String)"\u8bb0\u5f55\u4e1a\u52a1\u65e5\u5fd7\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)crmBusinessLogDto.getAppCode())) {
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isEmpty((CharSequence)crmBusinessLogDto.getTenantCode())) {
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        }
        String operationType = crmBusinessLogDto.getOperationType();
        crmBusinessLogDto.setAppName(this.appName);
        this.setBusinessLogBaseInfo(crmBusinessLogDto);
        if (StringUtils.isNotEmpty((CharSequence)crmBusinessLogDto.getCreateAccount())) {
            if (OperationTypeEunm.CREATE.getDictCode().equals(operationType)) {
                this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForAdd(crmBusinessLogDto));
            } else if (OperationTypeEunm.DELETE.getDictCode().equals(operationType)) {
                this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForDel(crmBusinessLogDto));
            } else if (OperationTypeEunm.ENABLE.getDictCode().equals(operationType)) {
                this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForEnableAndDisable(crmBusinessLogDto, OperationTypeEunm.ENABLE));
            } else if (OperationTypeEunm.DISABLE.getDictCode().equals(operationType)) {
                this.crmBusinessLogRepository.saveAll(CrmBusinessLogUtil.voToEntityForEnableAndDisable(crmBusinessLogDto, OperationTypeEunm.DISABLE));
            } else {
                Map<String, String> oldDateMap = this.transformDateFormat(crmBusinessLogDto.getOldObject());
                Map<String, String> newDateMap = this.transformDateFormat(crmBusinessLogDto.getNewObject());
                Object result = LogCompare.compareObject(JSON.toJSONString((Object)crmBusinessLogDto.getOldObject(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSON.toJSONString((Object)crmBusinessLogDto.getNewObject(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), oldDateMap, newDateMap, crmBusinessLogDto.getAppendMsg());
                this.crmBusinessLogRepository.save(CrmBusinessLogUtil.voToEntityForUpdate(crmBusinessLogDto, result));
            }
        }
    }

    private void setBusinessLogBaseInfo(CrmBusinessLogDto dto) {
        CompetenceCacheVoService competenceCacheVoService;
        CompetenceVo competenceVo;
        HttpServletRequest request;
        String menuCode;
        ServletRequestAttributes requestAttributes;
        if (Objects.nonNull(dto.getLoginUser())) {
            this.loginUserService.refreshAuthentication((Object)dto.getLoginUser());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getCreateAccount())) {
            AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
            dto.setCreateAccount(context.getAccount());
            dto.setCreateName(context.getRealName());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getMenuCode()) && (requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null && StringUtils.isNotEmpty((CharSequence)(menuCode = this.getHeaderMenuCode(request = requestAttributes.getRequest()))) && Objects.nonNull(competenceVo = (competenceCacheVoService = (CompetenceCacheVoService)SpringBeanUtils.getBean(CompetenceCacheVoService.class)).findCacheByCompetenceCode(menuCode))) {
            dto.setMenuCode(competenceVo.getCode());
            dto.setMenuName(competenceVo.getComment());
            dto.setMenuAllName(competenceVo.getParentCodeAllComment());
        }
    }

    private Map<String, String> transformDateFormat(Object crmBusinessLogDto) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        List<Class<?>> classes = CrmBusinessLogVoServiceImpl.getAll(crmBusinessLogDto);
        for (Class<?> aClass : classes) {
            Field[] declaredFields = aClass.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field declaredField = declaredFields[i];
                declaredField.setAccessible(true);
                if (declaredField.getType() != Date.class) continue;
                try {
                    String name = declaredField.getName();
                    Object date = declaredField.get(crmBusinessLogDto);
                    stringMap.put(name, dateFormat.format(date));
                    continue;
                }
                catch (Exception e) {
                    log.info("\u683c\u5f0f\u5316\u65e5\u671f\u9519\u8bef\uff0c\u8df3\u8fc7");
                }
            }
        }
        return stringMap;
    }

    public static List<Class<?>> getAll(Object o) {
        Boolean s = true;
        ArrayList classes = new ArrayList();
        classes.add(o.getClass());
        Class<?> superclass = o.getClass();
        while (s.booleanValue()) {
            if (!(superclass = superclass.getSuperclass()).getName().equals("java.lang.Object") && superclass != null) {
                classes.add(superclass);
                continue;
            }
            s = false;
        }
        return classes;
    }

    private String getHeaderMenuCode(HttpServletRequest request) {
        for (String headerKey : Constants.MENU_CODES) {
            String menuCode = request.getHeader(headerKey);
            if (!StringUtil.isNotEmpty((CharSequence)menuCode)) continue;
            return menuCode;
        }
        return "";
    }
}

