package com.biz.crm.common.log.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.log.local.service.CrmBusinessLogCommonService;
import com.biz.crm.common.log.sdk.dto.BusinessLogEventDto;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogUtilService;
import com.bizunited.nebula.common.util.SpringBeanUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.constant.Constants;
import com.bizunited.nebula.competence.sdk.service.CompetenceCacheVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.*;

/**
 * @description: 业务日志service
 * @author: rentao
 * @date: 2022/5/13 20:17
 */
@Service
@Slf4j
public class CrmBusinessLogUtilServiceImpl implements CrmBusinessLogUtilService {

    @Autowired(required = false)
    private CrmBusinessLogCommonService crmBusinessLogCommonService;

    @Autowired(required = false)
    private LoginUserService loginUserService;


    @Override
    public <T> void onCreate(BusinessLogEventDto<T> eventDto) {
        List<T> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = getFieldName(item);
                if (StringUtils.isBlank(id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty(menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty(menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty(menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                crmBusinessLogCommonService.onCreate(crmBusinessLogDto);
            } catch (Exception e) {
                log.error("创建操作日志保存失败", e);
            }
        });
    }

    @Override
    public <T> void onUpdate(BusinessLogEventDto<T> eventDto) {
        List<T> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
//        Assert.isTrue(vos.size() == 1, "更新操作日志单次只能保存一条记录");
        List<T> oldVos = this.findVoListByEventOriginalDto(eventDto);
        if (CollectionUtils.isEmpty(oldVos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        try {
            Map<String, Object> originalMap = Maps.newHashMap();
            oldVos.forEach(item -> {
                String id = getFieldName(item);
                if (StringUtils.isBlank(id)) {
                    return;
                }
                originalMap.put(id, item);
            });
            vos.forEach(newest -> {
                String id = getFieldName(newest);
                if (StringUtils.isBlank(id)) {
                    return;
                }
                if (!originalMap.containsKey(id)){
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                if (StringUtils.isNotBlank(eventDto.getOperationType())) {
                    crmBusinessLogDto.setOperationType(eventDto.getOperationType());
                } else {
                    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
                }
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(newest);
                crmBusinessLogDto.setOldObject(originalMap.get(id));
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty(menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty(menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty(menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                crmBusinessLogCommonService.onUpdate(crmBusinessLogDto);
            });

        } catch (Exception e) {
            log.error("更新操作日志保存失败", e);
        }

    }

    @Override
    public <T> void onDisable(BusinessLogEventDto<T> eventDto) {
        List<T> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = getFieldName(item);
                if (StringUtils.isBlank(id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.DISABLE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty(menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty(menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty(menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                crmBusinessLogCommonService.onDisable(crmBusinessLogDto);
            } catch (Exception e) {
                log.error("禁用操作日志保存失败", e);
            }
        });

    }

    @Override
    public <T> void onEnable(BusinessLogEventDto<T> eventDto) {
        List<T> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = getFieldName(item);
                if (StringUtils.isBlank(id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.ENABLE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty(menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty(menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty(menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                crmBusinessLogCommonService.onEnable(crmBusinessLogDto);
            } catch (Exception e) {
                log.error("启用操作日志保存失败", e);
            }
        });

    }

    @Override
    public <T> void onDelete(BusinessLogEventDto<T> eventDto) {
        List<T> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = getFieldName(item);
                if (StringUtils.isBlank(id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty(menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty(menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty(menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                crmBusinessLogCommonService.onDelete(crmBusinessLogDto);
            } catch (Exception e) {
                log.error("删除操作日志保存失败", e);
            }
        });
    }


    /**
     * 获取用户信息
     *
     * @param eventDto
     * @return
     */
    private <T> List<T> findVoListByEventDto(BusinessLogEventDto<T> eventDto) {
        List<T> ruleVos = Lists.newArrayList();
        if (Objects.isNull(eventDto)) {
            return ruleVos;
        }
        if (Objects.nonNull(eventDto.getNewest())) {
            ruleVos.add(eventDto.getNewest());
        }
        if (CollectionUtils.isNotEmpty(eventDto.getNewestList())) {
            ruleVos.addAll(eventDto.getNewestList());
        }
        return ruleVos;
    }/**
     * 获取用户信息
     *
     * @param eventDto
     * @return
     */
    private <T> List<T> findVoListByEventOriginalDto(BusinessLogEventDto<T> eventDto) {
        List<T> ruleVos = Lists.newArrayList();
        if (Objects.isNull(eventDto)) {
            return ruleVos;
        }
        if (Objects.nonNull(eventDto.getOriginal())) {
            ruleVos.add(eventDto.getOriginal());
        }
        if (CollectionUtils.isNotEmpty(eventDto.getOriginalList())) {
            ruleVos.addAll(eventDto.getOriginalList());
        }
        return ruleVos;
    }

    /**
     * 获取字段值
     *
     * @param object
     * @return
     */
    private <T> String getFieldName(T object) {
        return getFieldName(object, "id");
    }

    /**
     * 获取字段值
     *
     * @param object
     * @return
     */
    private <T> String getFieldName(T object, String fieldName) {
        try {
            Class<?> aClass = object.getClass();
            List<Field> fieldList = getAllFields(aClass);
            for (Field field : fieldList) {
                if (fieldName.equals(field.getName())) {
                    field.setAccessible(true);
                    return field.get(object).toString();
                }

            }
        } catch (IllegalAccessException e) {
            log.error("获取字段值失败", e);
        }
        return "";
    }

    /**
     * 获取所有字段
     *
     * @param clazz
     * @return
     */
    public static List<Field> getAllFields(Class<?> clazz) {
        List<Field> fieldList = Lists.newArrayList();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }


    /**
     * 设置菜单信息
     *
     * @return
     */
    private void setBusinessLogBaseInfo(CrmBusinessLogDto dto) {
        AbstractCrmUserIdentity crmUserIdentity = loginUserService.getAbstractLoginUser();
        dto.setLoginUser(crmUserIdentity);
        dto.setCreateAccount(crmUserIdentity.getAccount());
        dto.setCreateName(crmUserIdentity.getRealName());
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            String menuCode = getHeaderMenuCode(request);
            if (StringUtil.isNotEmpty(menuCode)) {
                CompetenceCacheVoService competenceCacheVoService = SpringBeanUtils.getBean(CompetenceCacheVoService.class);
                CompetenceVo competenceVo = competenceCacheVoService.findCacheByCompetenceCode(menuCode);
                if (Objects.nonNull(competenceVo)) {
                    dto.setMenuCode(competenceVo.getCode());
                    dto.setMenuName(competenceVo.getComment());
                    dto.setMenuAllName(competenceVo.getParentCodeAllComment());
                }
            }
        }
    }

    private String getHeaderMenuCode(HttpServletRequest request) {
        for (String headerKey : Constants.MENU_CODES) {
            String menuCode = request.getHeader(headerKey);
            if (StringUtil.isNotEmpty(menuCode)) {
                return menuCode;
            }
        }
        return "";
    }
}
