/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.log.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.log.local.service.CrmBusinessLogCommonService;
import com.biz.crm.common.log.sdk.dto.BusinessLogEventDto;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogUtilService;
import com.bizunited.nebula.common.util.SpringBeanUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.constant.Constants;
import com.bizunited.nebula.competence.sdk.service.CompetenceCacheVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class CrmBusinessLogUtilServiceImpl
implements CrmBusinessLogUtilService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessLogUtilServiceImpl.class);
    @Autowired(required=false)
    private CrmBusinessLogCommonService crmBusinessLogCommonService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public <T> void onCreate(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty((CharSequence)menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                this.crmBusinessLogCommonService.onCreate(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public <T> void onUpdate(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        List<Object> oldVos = this.findVoListByEventOriginalDto(eventDto);
        if (CollectionUtils.isEmpty(oldVos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        try {
            HashMap originalMap = Maps.newHashMap();
            oldVos.forEach(item -> {
                String id = this.getFieldName(item);
                if (StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                originalMap.put(id, item);
            });
            vos.forEach(newest -> {
                String id = this.getFieldName(newest);
                if (StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                if (!originalMap.containsKey(id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                if (StringUtils.isNotBlank((CharSequence)eventDto.getOperationType())) {
                    crmBusinessLogDto.setOperationType(eventDto.getOperationType());
                } else {
                    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
                }
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(newest);
                crmBusinessLogDto.setOldObject(originalMap.get(id));
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty((CharSequence)menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                this.crmBusinessLogCommonService.onUpdate(crmBusinessLogDto);
            });
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    public <T> void onDisable(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.DISABLE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty((CharSequence)menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                this.crmBusinessLogCommonService.onDisable(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u7981\u7528\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public <T> void onEnable(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.ENABLE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty((CharSequence)menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                this.crmBusinessLogCommonService.onEnable(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u542f\u7528\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public <T> void onDelete(BusinessLogEventDto<T> eventDto) {
        List<Object> vos = this.findVoListByEventDto(eventDto);
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        CrmBusinessLogDto baseDto = new CrmBusinessLogDto();
        this.setBusinessLogBaseInfo(baseDto);
        String appendMsg = eventDto.getAppendMsg();
        String menuCode = eventDto.getMenuCode();
        String menuName = eventDto.getMenuName();
        String menuAllName = eventDto.getMenuAllName();
        vos.forEach(item -> {
            try {
                String id = this.getFieldName(item);
                if (StringUtils.isBlank((CharSequence)id)) {
                    return;
                }
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
                crmBusinessLogDto.setOnlyKey(id);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setNewObject(item);
                crmBusinessLogDto.setLoginUser(baseDto.getLoginUser());
                crmBusinessLogDto.setMenuCode(baseDto.getMenuCode());
                crmBusinessLogDto.setMenuName(baseDto.getMenuName());
                crmBusinessLogDto.setMenuAllName(baseDto.getMenuAllName());
                crmBusinessLogDto.setCreateAccount(baseDto.getCreateAccount());
                crmBusinessLogDto.setCreateName(baseDto.getCreateName());
                crmBusinessLogDto.setAppendMsg(appendMsg);
                if (StringUtil.isNotEmpty((CharSequence)menuCode)) {
                    crmBusinessLogDto.setMenuCode(menuCode);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuName)) {
                    crmBusinessLogDto.setMenuName(menuName);
                }
                if (StringUtil.isNotEmpty((CharSequence)menuAllName)) {
                    crmBusinessLogDto.setMenuAllName(menuAllName);
                }
                this.crmBusinessLogCommonService.onDelete(crmBusinessLogDto);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u64cd\u4f5c\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private <T> List<T> findVoListByEventDto(BusinessLogEventDto<T> eventDto) {
        ArrayList ruleVos = Lists.newArrayList();
        if (Objects.isNull(eventDto)) {
            return ruleVos;
        }
        if (Objects.nonNull(eventDto.getNewest())) {
            ruleVos.add(eventDto.getNewest());
        }
        if (CollectionUtils.isNotEmpty((Collection)eventDto.getNewestList())) {
            ruleVos.addAll(eventDto.getNewestList());
        }
        return ruleVos;
    }

    private <T> List<T> findVoListByEventOriginalDto(BusinessLogEventDto<T> eventDto) {
        ArrayList ruleVos = Lists.newArrayList();
        if (Objects.isNull(eventDto)) {
            return ruleVos;
        }
        if (Objects.nonNull(eventDto.getOriginal())) {
            ruleVos.add(eventDto.getOriginal());
        }
        if (CollectionUtils.isNotEmpty((Collection)eventDto.getOriginalList())) {
            ruleVos.addAll(eventDto.getOriginalList());
        }
        return ruleVos;
    }

    private <T> String getFieldName(T object) {
        return this.getFieldName(object, "id");
    }

    private <T> String getFieldName(T object, String fieldName) {
        try {
            Class<?> aClass = object.getClass();
            List<Field> fieldList = CrmBusinessLogUtilServiceImpl.getAllFields(aClass);
            for (Field field : fieldList) {
                if (!fieldName.equals(field.getName())) continue;
                field.setAccessible(true);
                return field.get(object).toString();
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5931\u8d25", (Throwable)e);
        }
        return "";
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList fieldList = Lists.newArrayList();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    private void setBusinessLogBaseInfo(CrmBusinessLogDto dto) {
        CompetenceCacheVoService competenceCacheVoService;
        CompetenceVo competenceVo;
        HttpServletRequest request;
        String menuCode;
        AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
        dto.setLoginUser(crmUserIdentity);
        dto.setCreateAccount(crmUserIdentity.getAccount());
        dto.setCreateName(crmUserIdentity.getRealName());
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && StringUtil.isNotEmpty((CharSequence)(menuCode = this.getHeaderMenuCode(request = requestAttributes.getRequest()))) && Objects.nonNull(competenceVo = (competenceCacheVoService = (CompetenceCacheVoService)SpringBeanUtils.getBean(CompetenceCacheVoService.class)).findCacheByCompetenceCode(menuCode))) {
            dto.setMenuCode(competenceVo.getCode());
            dto.setMenuName(competenceVo.getComment());
            dto.setMenuAllName(competenceVo.getParentCodeAllComment());
        }
    }

    private String getHeaderMenuCode(HttpServletRequest request) {
        for (String headerKey : Constants.MENU_CODES) {
            String menuCode = request.getHeader(headerKey);
            if (!StringUtil.isNotEmpty((CharSequence)menuCode)) continue;
            return menuCode;
        }
        return "";
    }
}

