package com.biz.crm.common.log.sdk.service;


import com.biz.crm.common.log.sdk.dto.BusinessLogEventDto;

/**
 * 业务日志接口
 *
 * @author pengxi
 */
public interface CrmBusinessLogUtilService {
    /**
     * 当创建时触发
     *
     * @param eventDto 创建时的vo
     */
    <T> void onCreate(BusinessLogEventDto<T> eventDto);

    /**
     * 当修改时触发
     *
     * @param eventDto
     */
    <T> void onUpdate(BusinessLogEventDto<T> eventDto);

    /**
     * 当禁用时触发
     *
     * @param eventDto 禁用vo信息
     */
    <T> void onDisable(BusinessLogEventDto<T> eventDto);

    /**
     * 当启用时触发
     *
     * @param eventDto 禁用vo信息
     */
    <T> void onEnable(BusinessLogEventDto<T> eventDto);

    /**
     * 当删除时触发
     *
     * @param eventDto 删除vo信息
     */
    <T> void onDelete(BusinessLogEventDto<T> eventDto);

}
