package com.biz.crm.common.log.sdk.utils;

import com.biz.crm.common.log.sdk.dto.BusinessLogEventDto;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogUtilService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 日志
 *
 * @author huxmld
 */
@Component
public class BusinessLogUtil {

    private static CrmBusinessLogUtilService crmBusinessLogUtilService;

    @Autowired(required = false)
    public void setCrmBusinessLogUtilService(CrmBusinessLogUtilService utilService) {
        crmBusinessLogUtilService = utilService;
    }

    /**
     * 创建
     *
     * @param logDto
     */
    public static <T> void onCreate(BusinessLogEventDto<T> logDto) {
        crmBusinessLogUtilService.onCreate(logDto);

    }

    /**
     * 更新
     *
     * @param logDto
     */
    public static <T> void onUpdate(BusinessLogEventDto<T> logDto) {
        crmBusinessLogUtilService.onUpdate(logDto);

    }

    /**
     * 禁用
     *
     * @param logDto
     */
    public static <T> void onDisable(BusinessLogEventDto<T> logDto) {
        crmBusinessLogUtilService.onDisable(logDto);

    }

    /**
     * 启用
     *
     * @param logDto
     */
    public static <T> void onEnable(BusinessLogEventDto<T> logDto) {
        crmBusinessLogUtilService.onEnable(logDto);

    }

    /**
     * 删除
     *
     * @param logDto
     */
    public static <T> void onDelete(BusinessLogEventDto<T> logDto) {
        crmBusinessLogUtilService.onDelete(logDto);
    }

}
