package com.biz.crm.common.log.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 日志Dto
 *
 * @author pengxi
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BaseLogEventDto", description = "日志Dto")
public class BusinessLogEventDto<T> {

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("原始")
    private T original;

    @ApiModelProperty("最新")
    private T newest;

    @ApiModelProperty("最新集合")
    private List<T> newestList;

    @ApiModelProperty(value = "批量更新时,更新的基础信息")
    private T updateInfo;

    @ApiModelProperty("追加信息")
    private String appendMsg;

    @ApiModelProperty("菜单编码")
    private String menuCode;

    @ApiModelProperty("菜单描述(全)")
    private String menuAllName;

    @ApiModelProperty("菜单描述(简)")
    private String menuName;
}