package com.biz.crm.common.log.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description: 业务日志查询dto
 * @author: rentao
 * @date: 2022/5/23 11:12
 */
@Data
@ApiModel(value = "CrmBusinessLogDto", description = "业务日志查询dto")
public class CrmBusinessLogQueryDto {

    /**
     * 操作类型
     */
    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("业务数据id")
    private String onlyKey;

    @ApiModelProperty(name = "appCode", value = "品牌商租户编号")
    private String appCode;

    @ApiModelProperty("业务模块")
    private String appName;

    @ApiModelProperty("租户")
    private String tenantCode;

    @ApiModelProperty("菜单编码")
    private String menuCode;

    @ApiModelProperty("菜单描述(全)")
    private String menuAllName;

    @ApiModelProperty("菜单描述(简)")
    private String menuName;

    @ApiModelProperty("获取属性属性名称的编码")
    private String parentCode;

    @ApiModelProperty("页面引擎主表")
    private String functionCode;

    @ApiModelProperty("获取方式（此参数固定拿的是 CrmBusinessLogStrategyService 实现类里面的code)")
    private String accessType;

}
