package com.biz.crm.common.message.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 系统消息: SystemMessage: 系统消息
 *
 * @author sunx
 * @date 2022/7/4
 */
@Slf4j
@Api(tags = "系统消息: SystemMessage: 系统消息")
@RestController
@RequestMapping(value = {"/v1/systemMessage/systemMessage"})
public class SystemMessageVoController {
  @Autowired(required = false)
  private SystemMessageVoService systemMessageVoService;

  /**
   * 系统首页获取消息未读
   *
   * @return 系统首页获取消息未读
   */
  @ApiOperation(value = "系统首页获取消息未读")
  @GetMapping("/findHomeNotReadCount")
  public Result<Integer> findHomeNotReadCount() {
    try {
      return Result.ok(this.systemMessageVoService.findHomeNotReadCount());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
