package com.biz.crm.common.message.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.local.mapper.SystemMessageMapper;
import com.biz.crm.common.message.sdk.dto.SystemMessagePaginationDto;

import java.util.List;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 系统消息repository
 *
 * @author sunx
 * @date 2022/7/4
 */
@Component
public class SystemMessageRepository extends ServiceImpl<SystemMessageMapper, SystemMessage> {
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 分页查询
   *
   * @param page 分页
   * @param dto  查询参数
   * @return
   */
  public Page<SystemMessage> findByConditions(
          Page<SystemMessage> page, SystemMessagePaginationDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 查询未读数据条数
   * @return
   */
  public Integer findNotReadCount() {
    return this.lambdaQuery().eq(SystemMessage::getTenantCode, TenantUtils.getTenantCode())
            .eq(SystemMessage::getReadFlag, BooleanEnum.FALSE)
            .eq(SystemMessage::getBusinessCode, loginUserService.getLoginAccountName())
            .count();
  }

  /**
   * 根据id获取通知详情信息
   *
   * @param ids 主键集合
   * @return
   */
  public List<SystemMessage> findByIds(List<String> ids) {
    return this.baseMapper.selectBatchIds(ids);
  }

  /**
   * 携带当前用户
   * @return
   */
  public Integer findHomeNotReadCount() {
    return this.lambdaQuery().eq(SystemMessage::getTenantCode, TenantUtils.getTenantCode())
            .eq(SystemMessage::getReadFlag, BooleanEnum.FALSE)
            .eq(SystemMessage::getBusinessCode, loginUserService.getLoginAccountName())
            .count();
  }

  /**
   *    通过登录人 将所有消息都变成已读
   * @param account
   */
  public void updateReadByBusinessCode(String account) {
     this.lambdaUpdate()
         .eq(SystemMessage::getBusinessCode,account)
         .set(SystemMessage::getReadFlag,Boolean.TRUE)
         .update();
  }
}
