package com.biz.crm.common.message.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.sdk.dto.SystemMessagePaginationDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author sunx
 * @date 2022/7/4
 */
public interface SystemMessageService {

  /**
   * 系统消息分页查询
   *
   * @param pageable      分页
   * @param paginationDto 查询参数
   * @return
   */
  Page<SystemMessage> findByConditions(Pageable pageable, SystemMessagePaginationDto paginationDto);

  /**
   * 标为已读
   *
   * @param ids 主键集合
   */
  void read(List<String> ids);

  /**
   * 获取未读消息数量
   */
  Integer findNotReadCount();




  /**
   * 批量新增消息
   *
   * @param data 消息
   */
  void createBatch(List<SystemMessage> data);

  /**
   * 全部标记为已读
   */
  void readAll();
}
