package com.biz.crm.common.message.local.service.internal;

import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.sdk.register.SystemMessageRegister;
import com.biz.crm.common.message.sdk.service.SendMessageVoService;
import com.biz.crm.common.message.sdk.service.SystemMessageTypeService;
import java.util.List;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 消息发送sdk实现
 *
 * @author sunx
 * @date 2022/7/5
 */
@Service
public class SendMessageVoServiceImpl implements SendMessageVoService {
  @Autowired(required = false)
  private SystemMessageTypeService systemMessageTypeService;

  @Override
  @Transactional
  public void send(SysMessageDto dto) {
    final SystemMessageRegister register = this.systemMessageTypeService.findByCode(dto.getCode());
    Validate.notNull(register, "系统消息对应的注册器不存在");
    register.sendMessage(dto.getMap());
  }

  @Override
  @Transactional
  public void batchSend(List<SysMessageDto> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    for (SysMessageDto item : list) {
      this.send(item);
    }
  }
}
