/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.sdk.service.SendMessageVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u6d88\u606f\u63a8\u9001: SysMessageDto: \u7cfb\u7edf\u6d88\u606f\u63a8\u9001"})
@RestController
@RequestMapping(value={"/v1/systemMessage"})
public class SendMessageVoController {
    private static final Logger log = LoggerFactory.getLogger(SendMessageVoController.class);
    @Autowired(required=false)
    private SendMessageVoService sendMessageVoService;

    @ApiOperation(value="\u53d1\u9001\u6d88\u606f")
    @PostMapping(value={"/send"})
    public Result<?> send(@RequestBody SysMessageDto dto) {
        try {
            this.sendMessageVoService.send(dto);
            return Result.ok((String)"\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u53d1\u9001\u6d88\u606f")
    @PostMapping(value={"/sendBatch"})
    public Result<?> sendBatch(@RequestBody List<SysMessageDto> list) {
        try {
            this.sendMessageVoService.batchSend(list);
            return Result.ok((String)"\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

