package com.biz.crm.common.message.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.sdk.service.SendMessageVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统消息推送: SystemMessageVo: 系统消息推送
 *
 * @author sunx
 * @date 2022/7/5
 */
@Slf4j
@Api(tags = "系统消息推送: SysMessageDto: 系统消息推送")
@RestController
@RequestMapping(value = {"/v1/systemMessage"})
public class SendMessageVoController {

  @Autowired(required = false)
  private SendMessageVoService sendMessageVoService;

  /**
   * 发送消息
   *
   * @param dto 消息实体
   * @return
   */
  @ApiOperation(value = "发送消息")
  @PostMapping("/send")
  public Result send(@RequestBody SysMessageDto dto) {
    try {
      this.sendMessageVoService.send(dto);
      return Result.ok("成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量发送消息
   *
   * @param list 消息实体集合
   * @return
   */
  @ApiOperation(value = "批量发送消息")
  @PostMapping("/sendBatch")
  public Result sendBatch(@RequestBody List<SysMessageDto> list) {
    try {
      this.sendMessageVoService.batchSend(list);
      return Result.ok("成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
