package com.biz.crm.common.message.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.local.service.SystemMessageService;
import com.biz.crm.common.message.sdk.dto.SystemMessagePaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 系统消息: SystemMessage: 系统消息
 *
 * @author sunx
 * @date 2022/7/4
 */
@Slf4j
@Api(tags = "系统消息: SystemMessage: 系统消息")
@RestController
@RequestMapping(value = {"/v1/systemMessage/systemMessage"})
public class SystemMessageController {
  @Autowired(required = false)
  private SystemMessageService systemMessageService;

  /**
   * 查询分页列表
   *
   * @param pageable      分页
   * @param paginationDto 查询参数
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<SystemMessage>> findByConditions(
          @PageableDefault(50) Pageable pageable, SystemMessagePaginationDto paginationDto) {
    try {
      Page<SystemMessage> result =
              this.systemMessageService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 标为已读
   *
   * @param ids 主键集合
   * @return
   */
  @ApiOperation(value = "标为已读")
  @PostMapping("/read")
  public Result read(@RequestBody List<String> ids) {
    try {
      this.systemMessageService.read(ids);
      return Result.ok("成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 通过登录人 将通知全部标为已读
   *
   * @return
   */
  @ApiOperation(value = "全部标为已读")
  @PostMapping("/readAll")
  public Result readAll() {
    try {
      this.systemMessageService.readAll();
      return Result.ok("成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取未读消息数量
   *
   * @return 未读消息
   */
  @ApiOperation(value = "获取未读消息数量")
  @GetMapping("/findNotReadCount")
  public Result<Integer> findNotReadCount() {
    try {
      return Result.ok(this.systemMessageService.findNotReadCount());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
