package com.biz.crm.common.message.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.local.repository.SystemMessageRepository;
import com.biz.crm.common.message.local.service.SystemMessageService;
import com.biz.crm.common.message.sdk.dto.SystemMessagePaginationDto;
import com.biz.crm.common.message.sdk.register.SystemMessageRegister;
import com.biz.crm.common.message.sdk.service.SystemMessageTypeService;
import com.biz.crm.common.message.sdk.vo.PageResultExpandVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 系统消息接口实现
 *
 * @author sunx
 * @date 2022/7/4
 */
@Service
public class SystemMessageServiceImpl implements SystemMessageService {
  @Autowired(required = false)
  private SystemMessageRepository systemMessageRepository;

  @Autowired(required = false)
  private SystemMessageTypeService systemMessageTypeService;

  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Override
  public Page<SystemMessage> findByConditions(Pageable pageable, SystemMessagePaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    dto = Optional.ofNullable(dto).orElse(new SystemMessagePaginationDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<SystemMessage> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    final Page<SystemMessage> result = this.systemMessageRepository.findByConditions(page, dto);

    if (Objects.nonNull(result) && !CollectionUtils.isEmpty(result.getRecords())) {
      for (SystemMessage item : result.getRecords()) {
        final SystemMessageRegister register =
            this.systemMessageTypeService.findByCode(item.getMessageCode());
        if (Objects.isNull(register)) {
          continue;
        }
        item.setMessageName(register.getName());
      }
    }
    //封装当前未读消息
    int unReadCount = this.findNotReadCount();
    PageResultExpandVo pageResultExpand = new PageResultExpandVo();
    BeanUtils.copyProperties(result, pageResultExpand);
    pageResultExpand.setUnreadTotal(unReadCount);
    return pageResultExpand;
  }

  @Override
  @Transactional
  public void read(List<String> ids) {
    List<SystemMessage> list = this.systemMessageRepository.findByIds(ids);
    Validate.isTrue(!CollectionUtils.isEmpty(list), "未获取到对应的消息！");
    final List<SystemMessage> messages =
        list.stream()
            .filter(a -> Boolean.FALSE.equals(a.getReadFlag()))
            .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(messages)) {
      return;
    }
    for (SystemMessage item : messages) {
      item.setReadFlag(Boolean.TRUE);
    }
    this.systemMessageRepository.saveOrUpdateBatch(messages);
  }

  @Override
  public Integer findNotReadCount() {
    return this.systemMessageRepository.findNotReadCount();
  }



  @Override
  @Transactional
  public void createBatch(List<SystemMessage> data) {
    if (CollectionUtils.isEmpty(data)) {
      return;
    }
    this.systemMessageRepository.saveBatch(data);
  }

  @Override
  public void readAll() {
    AbstractCrmUserIdentity loginDetails = loginUserService.getAbstractLoginUser();
    Validate.isTrue(!ObjectUtils.isEmpty(loginDetails),"没有登录信息");
    String account = loginDetails.getAccount();
    //通过登录人 将所有消息都变成已读
    systemMessageRepository.updateReadByBusinessCode(account);
  }
}
