package com.biz.crm.common.message.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.message.sdk.dto.SystemMessageTypeQueryDto;
import com.biz.crm.common.message.sdk.service.SystemMessageTypeService;
import com.biz.crm.common.message.sdk.vo.SystemMessageTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统消息通知类型: SystemMessageType: 系统消息通知类型
 *
 * @author sunx
 * @date 2022/7/4
 */
@Slf4j
@Api(tags = "系统消息通知类型: SystemMessageType: 系统消息通知类型")
@RestController
@RequestMapping(value = {"/v1/systemMessageType"})
public class SystemMessageTypeController {

  @Autowired(required = false)
  private SystemMessageTypeService systemMessageTypeService;

  /**
   * 系统消息总览
   *
   * @param dto 消息查询实体
   * @return
   */
  @ApiOperation(value = "系统消息总览")
  @GetMapping(value = {"/systemMessageType/findBySystemMessageTypeQueryDto"})
  public Result<List<SystemMessageTypeVo>> findBySystemMessageTypeQueryDto(
      SystemMessageTypeQueryDto dto) {
    try {
      return Result.ok(this.systemMessageTypeService.findBySystemMessageTypeQueryDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
