/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.sdk.util;

import java.text.MessageFormat;
import java.util.Map;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.PropertyPlaceholderHelper;

public class ContentHolderUtil {
    private static final String PLACE_HOLDER_PREFIX = "${";
    private static final String PLACE_HOLDER_SUFFIX = "}";
    private static final StandardEvaluationContext EVALUATION_CONTEXT;
    private static final PropertyPlaceholderHelper PROPERTY_PLACEHOLDER_HELPER;

    private ContentHolderUtil() {
    }

    public static String replacePlaceHolder(String template, Map<String, String> paramMap) {
        return PROPERTY_PLACEHOLDER_HELPER.replacePlaceholders(template, (PropertyPlaceholderHelper.PlaceholderResolver)new CustomPlaceholderResolver(template, paramMap));
    }

    static {
        PROPERTY_PLACEHOLDER_HELPER = new PropertyPlaceholderHelper(PLACE_HOLDER_PREFIX, PLACE_HOLDER_SUFFIX);
        EVALUATION_CONTEXT = new StandardEvaluationContext();
        EVALUATION_CONTEXT.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    private static class CustomPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String template;
        private final Map<String, String> paramMap;

        public CustomPlaceholderResolver(String template, Map<String, String> paramMap) {
            this.template = template;
            this.paramMap = paramMap;
        }

        public String resolvePlaceholder(String placeholderName) {
            String value = this.paramMap.get(placeholderName);
            if (null == value) {
                String errorStr = MessageFormat.format("template:{0} require param:{1},but not exist!", this.template, placeholderName);
                throw new IllegalArgumentException(errorStr);
            }
            return value;
        }
    }
}

