package com.biz.crm.common.message.sdk.register;

import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 系统消息注册器
 *
 * @author sunx
 * @date 2022/7/4
 */
public interface SystemMessageRegister {

  /**
   * 系统消息通知类型编码
   *
   * @return
   */
  String getCode();

  /**
   * 系统消息通知类型名称
   *
   * @return
   */
  String getName();

  /**
   * 系统消息通知类型触发规则描述
   *
   * @return
   */
  default String getDesc() {
    return StringUtils.EMPTY;
  }

  /**
   * 系统消息通知实现方式
   *
   * @return
   */
  List<SystemMessageHandlerRegister> getHandlerRegisterList();

  /**
   * 排序
   *
   * @return
   */
  default int getOrder() {
    return 0;
  }

  /**
   * 消息发送具体实现
   *
   * @param map k-消息发送处理器编码，v-消息发送参数
   */
  @Transactional
  default void sendMessage(Map<String, List<SysMessageItemDto>> map) {
    final List<SystemMessageHandlerRegister> registers = this.getHandlerRegisterList();
    Validate.isTrue(!CollectionUtils.isEmpty(registers), "不存在消息发送的处理器!");
    Map<String, SystemMessageHandlerRegister> mapRegister =
            registers.stream().collect(Collectors.toMap(SystemMessageHandlerRegister::getCode, v -> v, (a, b) -> a));
    for (Entry<String, List<SysMessageItemDto>> item : map.entrySet()) {
      final SystemMessageHandlerRegister register = mapRegister.get(item.getKey());
      Validate.notNull(register, item.getKey() + "对应的处理器不存在！");
      register.sendMessage(this.getCode(), item.getValue());
    }
  }
}
