package com.biz.crm.common.message.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 系统消息vo
 *
 * @author ning.zhang
 * @date 2022/9/14
 */
@Data
@ApiModel(value = "SystemMessageVo", description = "系统消息vo")
public class SystemMessageVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 888433297349770904L;

  /**
   * 关联业务员编码
   */
  @ApiModelProperty("关联业务员编码")
  private String businessCode;

  /**
   * 关联业务员类型
   */
  @ApiModelProperty("关联业务员类型")
  private String businessType;

  /**
   * 关联业务单据号
   */
  @ApiModelProperty("关联业务单据号")
  private String relateCode;

  /**
   * 关联业务类型
   */
  @ApiModelProperty("关联业务类型")
  private String relateType;

  /**
   * 消息通知类型编码
   */
  @ApiModelProperty("消息通知类型编码")
  private String messageCode;

  /**
   * 消息内容
   */
  @ApiModelProperty("消息内容")
  private String content;

  /**
   * 是否已读
   */
  @ApiModelProperty("是否已读")
  private Boolean readFlag;

  /**
   * 消息通知类型名称
   */
  @ApiModelProperty("消息通知类型名称")
  private String messageName;
}
