package com.biz.crm.common.message.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 消息通知方式枚举
 *
 * @author sunx
 * @date 2022/7/4
 */
@Getter
@AllArgsConstructor
public enum MessageHandlerEnum {
  /** 消息通知方式枚举 */
  CLOSE_ORDER_USER("close_order_user", "close_order_user", "企业人员管理端", "0"),
  CLOSE_ORDER_CUSTOMER("close_order_customer", "close_order_customer", "商城", "1"),
  DELIVERY_DELAY_USER("delivery_delay_user", "delivery_delay_user", "企业人员管理端", "2"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
