package com.biz.crm.common.message.sdk.dto;

import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import lombok.Data;

/**
 * 系统消息dto
 *
 * @author sunx
 * @date 2022/7/4
 */
@Data
@ApiModel(value = "SysMessageDto", description = "系统消息dto")
public class SysMessageDto {

  /** 消息类型编码，SystemMessageRegister -> code */
  @ApiModelProperty(value = "消息类型编码")
  private String code;

  /** 消息类型具体推送方式及参数，k-SystemMessageHandlerRegister->code,v-推送人员参数信息 */
  @ApiModelProperty(value = "消息类型具体推送方式及参数")
  private Map<String, List<SysMessageItemDto>> map;
}
