package com.biz.crm.common.message.sdk.service;

import com.biz.crm.common.message.sdk.dto.SystemMessageTypeQueryDto;
import com.biz.crm.common.message.sdk.register.SystemMessageHandlerRegister;
import com.biz.crm.common.message.sdk.register.SystemMessageRegister;
import com.biz.crm.common.message.sdk.vo.SystemMessageTypeVo;
import java.util.List;
import java.util.Set;

/**
 * 系统消息通知类型sdk
 *
 * @author sunx
 * @date 2022/7/4
 */
public interface SystemMessageTypeService {

  /**
   * 根据SystemMessageTypeQueryDto获取通知方式集合
   *
   * @param dto 通知类型查询dto
   * @return
   */
  List<SystemMessageTypeVo> findBySystemMessageTypeQueryDto(SystemMessageTypeQueryDto dto);

  /**
   * 根据通知类型编码获取注册器明细
   *
   * @param code 处理器编码
   * @return
   */
  SystemMessageRegister findByCode(String code);

  /**
   * 根据处理器编码编码集合获取处理器信息
   *
   * @param codes 处理器编码集合
   * @return
   */
  List<SystemMessageHandlerRegister> findHandlerByCodes(Set<String> codes);
}
