package com.biz.crm.common.message.sdk.register;

import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import java.util.List;

/**
 * 系统同事处理器实现
 *
 * @author sunx
 * @date 2022/7/4
 */
public interface SystemMessageHandlerRegister {

  /**
   * 处理器编码
   *
   * @return
   */
  String getCode();

  /**
   * 处理器名称
   *
   * @return
   */
  String getName();

  /**
   * 被通知方
   *
   * @return
   */
  String getNoticeDesc();

  /**
   * 模板消息内容，占位符 ${key}
   *
   * @return
   */
  String getContent();

  /**
   * 排序
   *
   * @return
   */
  default int getOrder() {
    return 0;
  }

  /**
   * 消息发送具体实现
   *
   * @param messageCode 系统消息类型编码
   * @param list 消息明细dto集合
   */
  void sendMessage(String messageCode, List<SysMessageItemDto> list);
}
