package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.biz.crm.common.pay.business.sdk.dto.PayBusinessDto;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import com.biz.crm.common.pay.business.sdk.dto.WithdrawalDto;
import com.biz.crm.common.pay.business.sdk.enums.PayOperationType;
import com.biz.crm.common.pay.business.sdk.enums.PayRecordOperationTypeEnum;
import com.biz.crm.common.pay.business.sdk.enums.PayWayEnum;
import com.biz.crm.common.pay.business.sdk.service.PaymentOperationVoService;
import com.biz.crm.common.pay.business.sdk.service.PaymentRecordVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentOperationVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentRecordVo;
import com.biz.crm.common.pay.support.sdk.dto.ExtractCashDto;
import com.biz.crm.common.pay.support.sdk.dto.transfer.AppletPayDto;
import com.biz.crm.common.pay.support.sdk.dto.transfer.PayDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.CustomerPaySupportVoService;
import com.biz.crm.common.pay.support.sdk.service.CustomerRechargeSupportVoService;
import com.biz.crm.common.pay.support.sdk.service.ExtractCashService;
import com.biz.crm.common.pay.support.sdk.service.TxSnGenerateService;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Redirect7Wechat7Applet;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Scan7Aggregate7Forward;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.biz.crm.common.weixinsign.sdk.service.WXOpenVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月16日 15:13:00
 */
@Service
@Slf4j
public class PaymentOperationVoServiceImpl implements PaymentOperationVoService {

  @Autowired(required = false)
  private ExtractCashService extractCashService;
  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CustomerRechargeSupportVoService customerRechargeSupportVoService;
  @Autowired
  private PaymentAccountService paymentAccountService;
  @Autowired(required = false)
  private PaymentRecordVoService paymentRecordVoService;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired(required = false)
  private CustomerPaySupportVoService customerPaySupportVoService;
  @Autowired(required = false)
  private TxSnGenerateService txSnGenerateService;
  @Autowired(required = false)
  private WXOpenVoService wxOpenVoService;
  @Value("${weixing.dms.appID}")
  private String appID;
  @Value("${weixing.dms.openID}")
  private String openID;
  /**
   * 在线支付流水充值编码前缀
   */
  private static final String RECHARGE_RULE_CODE = "CZ";

  /**
   * 提现
   *
   * @param dto
   * @return
   */
  @Override
  public String withdrawal(WithdrawalDto dto) {
    /**
     *  1. 校验
     *  2. 从上下文中取相关信息，并转换对象
     *  3. 调用提现
     */
    //校验
    Validate.notNull(dto, "提现时，对象数据不能为空!");
    String verificationCode = dto.getVerificationCode();
    Validate.notBlank(verificationCode, "验证码不能为空!");
    //验证码区分业务
    verificationCode = verificationCode.concat(PayOperationType.WITHDRAWAL.getDictCode());
    Boolean availableVerificationCode = validitySmsCodeService.isAvailableVerificationCode(dto.getPhoneNumber(), verificationCode);
    Validate.isTrue(availableVerificationCode, "验证码错误或者失效!");
    ExtractCashDto extractCashDto = new ExtractCashDto();
    extractCashDto.setAmount(dto.getAmount());
    extractCashDto.setBankAccountNumber(dto.getBindingTxSN());
    extractCashDto.setArrivalType(dto.getArrivalType());
    PaymentAccount localUserInfo = paymentAccountService.findLocalUserInfo();
    extractCashDto.setUserID(localUserInfo.getUserId());
    ResponseModel model = extractCashService.sendRequest(extractCashDto);
    Validate.notNull(model, "提现失败!");
    Validate.isTrue(model.getSuccess(), model.getMessage());
    return model.getMessage();
  }

  /**
   * 充值
   *
   * @param dto
   * @return
   */
  @Override
  @Transactional
  public PaymentOperationVo recharge(PayBusinessDto dto) {
    Validate.notNull(dto, "数据对象不能为空");
    Validate.notBlank(dto.getPayWay(), "支付方式不能为空");
    PaymentAccount localUserInfo = paymentAccountService.findLocalUserInfo();
    String txSn = txSnGenerateService.create();
    Object vo = null;
    if (dto.getPayWay().equals(PayWayEnum.QR.getDictCode())) {
      //扫码支付
      PayDto payDto = new PayDto();
      payDto.setAmount(dto.getAmount());
      payDto.setPayerUserID(dto.getPayerUserID());
      payDto.setRemark(dto.getRemark());
      payDto.setExpirePeriod("15m");
      payDto.setTxSN(txSn);
      payDto.setGoodsName(dto.getGoodsName());
      payDto.setOrderNo(dto.getOrderNo());
      payDto.setPayeeUserID(localUserInfo.getUserId());
      Scan7Aggregate7Forward scan7Aggregate7Forward = new Scan7Aggregate7Forward(payDto);
      ResponseModel recharge = customerRechargeSupportVoService.recharge(scan7Aggregate7Forward);
      vo = scan7Aggregate7Forward.getVo(recharge.getResponse());
      Validate.notNull(vo, "中金错误信息:" + recharge.getMessage());
    } else {
      AppletPayDto appletPayDto = new AppletPayDto();
      appletPayDto.setGoodsName(dto.getGoodsName());
      appletPayDto.setAmount(dto.getAmount());
      appletPayDto.setSubAppID(dto.getSubAppID());
      appletPayDto.setSubOpenID(dto.getSubOpenID());
      appletPayDto.setPayerUserID(dto.getPayerUserID());
      appletPayDto.setRemark(dto.getRemark());
      appletPayDto.setExpirePeriod("15m");
      appletPayDto.setTxSN(txSn);
      appletPayDto.setOrderNo(dto.getOrderNo());
      appletPayDto.setPayeeUserID(localUserInfo.getUserId());
      appletPayDto.setSubAppID(appID);
      appletPayDto.setSubOpenID(openID);
      Redirect7Wechat7Applet redirect7Wechat7Applet = new Redirect7Wechat7Applet(appletPayDto);
      ResponseModel recharge = customerRechargeSupportVoService.recharge(redirect7Wechat7Applet);
      vo = redirect7Wechat7Applet.getVo(recharge.getResponse());
      Validate.notNull(vo, "中金错误信息:" + recharge.getMessage());
    }
    //保存流水记录
    PaymentRecordDto paymentRecordDto = new PaymentRecordDto();
    //中金支付 金额单位是分 ，故单位需要转成元
    BigDecimal amount = new BigDecimal(dto.getAmount());
    BigDecimal hundred = new BigDecimal("100");
    BigDecimal actualAmount = amount.divide(hundred);
    paymentRecordDto.setAmount(actualAmount);
    paymentRecordDto.setOperationType(PayRecordOperationTypeEnum.RECHARGE.getDictCode());
    paymentRecordDto.setOperationTime(new Date());
    paymentRecordDto.setTxSn(txSn);
    paymentRecordDto.setCustomerCode(dto.getCustomerCode());
    //生成充值流水编码
    List<String> strings = generateCodeService.generateCode(RECHARGE_RULE_CODE, 1);
    paymentRecordDto.setRelationshipDocNumber(strings.get(0));
    paymentRecordVoService.create(paymentRecordDto);
    return this.nebulaToolkitService.copyObjectByWhiteList(vo, PaymentOperationVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 在线支付
   *
   * @param dto
   * @return
   */
  @Override
  @Transactional
  public PaymentOperationVo pay(PayBusinessDto dto) {
    /*
    1.判断当前订单是否存在可用的二维码或者授权码信息
    2.不存在可用的二维码或者授权码，向中金提起支付获取
    3.保存或更新流水
     */
    Validate.notNull(dto, "数据对象不能为空");
    Validate.notBlank(dto.getPayWay(), "支付方式不能为空");
    Validate.notBlank(dto.getOrderNo(), "订单号不能为空!");
    PaymentRecordVo byOrderNo = this.paymentRecordVoService.findByOrderNo(dto.getOrderNo());
    //1.判断当前订单是否存在未过期可用的二维码或者授权码
    if (dto.getPayWay().equals(PayWayEnum.QR.getDictCode())) {
      //扫码
      if (Objects.nonNull(byOrderNo) && StringUtils.isNoneBlank(byOrderNo.getQrCodeUrl(), byOrderNo.getQrImageUrl())) {
        PaymentOperationVo operationVo = new PaymentOperationVo();
        operationVo.setQRCodeURL(byOrderNo.getQrCodeUrl());
        operationVo.setQRImageURL(byOrderNo.getQrImageUrl());
        operationVo.setQRAuthCode(byOrderNo.getQrAuthCode());
        return operationVo;
      }
    } else {
      //跳转
      if (Objects.nonNull(byOrderNo) && StringUtils.isNoneBlank(byOrderNo.getQrAuthCode())) {
        PaymentOperationVo operationVo = new PaymentOperationVo();
        operationVo.setQRCodeURL(byOrderNo.getQrCodeUrl());
        operationVo.setQRImageURL(byOrderNo.getQrImageUrl());
        operationVo.setQRAuthCode(byOrderNo.getQrAuthCode());
        return operationVo;
      }
    }
    //2.不存在可用的二维码或者授权码 则向中金重新申请
    PaymentAccount localUserInfo = paymentAccountService.findLocalUserInfo();
    String txSn = txSnGenerateService.create();
    Object vo = null;
    if (dto.getPayWay().equals(PayWayEnum.QR.getDictCode())) {
      PayDto payDto = new PayDto();
      payDto.setAmount(dto.getAmount());
      payDto.setPayerUserID(dto.getPayerUserID());
      payDto.setRemark(dto.getRemark());
      payDto.setExpirePeriod("15m");
      payDto.setOrderNo(dto.getOrderNo());
      payDto.setGoodsName(dto.getGoodsName());
      payDto.setTxSN(txSn);
      payDto.setPayeeUserID(localUserInfo.getUserId());
      Scan7Aggregate7Forward scan7Aggregate7Forward = new Scan7Aggregate7Forward(payDto);
      ResponseModel pay = customerPaySupportVoService.pay(scan7Aggregate7Forward);
      vo = scan7Aggregate7Forward.getVo(pay.getResponse());
      Validate.notNull(vo, "中金错误信息:" + pay.getMessage());
    } else {
      AppletPayDto appletPayDto = new AppletPayDto();
      appletPayDto.setGoodsName(dto.getGoodsName());
      appletPayDto.setAmount(dto.getAmount());
      appletPayDto.setSubAppID(dto.getSubAppID());
      appletPayDto.setSubOpenID(dto.getSubOpenID());
      appletPayDto.setPayerUserID(dto.getPayerUserID());
      appletPayDto.setRemark(dto.getRemark());
      appletPayDto.setExpirePeriod("15m");
      appletPayDto.setTxSN(txSn);
      appletPayDto.setOrderNo(dto.getOrderNo());
      appletPayDto.setPayeeUserID(localUserInfo.getUserId());
      appletPayDto.setSubAppID(appID);
      appletPayDto.setSubOpenID(openID);
      Redirect7Wechat7Applet redirect7Wechat7Applet = new Redirect7Wechat7Applet(appletPayDto);
      ResponseModel pay = customerPaySupportVoService.pay(redirect7Wechat7Applet);
      vo = redirect7Wechat7Applet.getVo(pay.getResponse());
      Validate.notNull(vo, "中金错误信息:" + pay.getMessage());
    }
    PaymentOperationVo operationVo = this.nebulaToolkitService.copyObjectByWhiteList(vo, PaymentOperationVo.class, HashSet.class, ArrayList.class);
    //3.
    if (Objects.isNull(byOrderNo)) {
      //如果不存在流水信息，则当前订单没有进行过任何支付
      //保存新流水记录
      PaymentRecordDto paymentRecordDto = new PaymentRecordDto();
      //中金支付 金额单位是分 ，故单位需要转成元
      BigDecimal amount = new BigDecimal(dto.getAmount());
      BigDecimal hundred = new BigDecimal("100");
      BigDecimal actualAmount = amount.divide(hundred);
      paymentRecordDto.setAmount(actualAmount);
      paymentRecordDto.setOperationType(PayRecordOperationTypeEnum.ORDER.getDictCode());
      paymentRecordDto.setOperationTime(new Date());
      paymentRecordDto.setTxSn(txSn);
      paymentRecordDto.setRelationshipDocNumber(dto.getOrderNo());
      paymentRecordDto.setCustomerCode(dto.getCustomerCode());
      paymentRecordDto.setRelationshipDocNumber(dto.getOrderNo());
      paymentRecordDto.setQrAuthCode(operationVo.getQRAuthCode());
      paymentRecordDto.setQrCodeUrl(operationVo.getQRCodeURL());
      paymentRecordDto.setQrImageUrl(operationVo.getQRImageURL());
      paymentRecordVoService.create(paymentRecordDto);
    }else {
      //如果存在流水信息，则更新二维码或者授权码
      byOrderNo.setQrAuthCode(operationVo.getQRAuthCode());
      byOrderNo.setQrCodeUrl(operationVo.getQRCodeURL());
      byOrderNo.setQrImageUrl(operationVo.getQRImageURL());
      byOrderNo.setOperationTime(new Date());
      paymentRecordVoService.update(this.nebulaToolkitService.copyObjectByWhiteList(byOrderNo,PaymentRecordDto.class,HashSet.class,ArrayList.class));
    }
    return operationVo;
  }
}
