package com.biz.crm.common.pay.business.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.pay.business.local.entity.PaymentRecord;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import org.apache.ibatis.annotations.Param;

/**
 * 支付流水表(PaymentRecord)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2022-08-12 14:02:56
 */
public interface PaymentRecordMapper extends BaseMapper<PaymentRecord> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto 查询实体
   * @return 所有数据
  */
  public Page<PaymentRecord> findByConditions(@Param("page") Page<PaymentRecord> page, @Param("dto") PaymentRecordDto dto);
}

