package com.biz.crm.common.pay.business.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.pay.business.local.entity.PaymentAccountBank;
import com.biz.crm.common.pay.business.local.mapper.PaymentAccountBankMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 电子账户绑定银行卡信息(MdmPaymentAccountBank)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2022-08-18 11:47:54
 */
@Component
public class PaymentAccountBankRepository extends ServiceImpl<PaymentAccountBankMapper, PaymentAccountBank> {

  @Autowired
  private PaymentAccountBankMapper paymentAccountBankMapper;


  /**
   * 账户ID查询绑定卡
   *
   * @param accountId
   * @return
   */
  public List<PaymentAccountBank> findByAccountId(String accountId) {
    return this.lambdaQuery()
        .eq(PaymentAccountBank::getAccountId, accountId)
        .list();
  }

  public void deleteByAccountId(String accountId) {
    this.lambdaUpdate()
        .eq(PaymentAccountBank::getAccountId, accountId)
        .remove();
  }
}


