package com.biz.crm.common.pay.business.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月17日 15:15:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PaymentAccount", description = "电子账户信息表")
@Entity
@TableName("mdm_payment_account")
@Table(
    name = "mdm_payment_account")
@org.hibernate.annotations.Table(appliesTo = "mdm_payment_account", comment = "电子账户信息表")
public class PaymentAccount extends TenantFlagOpEntity {

  @ApiModelProperty("账户流水码")
  @Column(name = "code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '账户流水码'")
  private String code;
  /**
   * 账户信息
   */

  /** 账户名称 **/
  @ApiModelProperty("账户名称")
  @Column(name = "account_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '账户名称'")
  private String accountName;
  /** 账户编码 **/
  @ApiModelProperty("账户编码")
  @Column(name = "account_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '账户编码'")
  private String accountCode;
  /** 账户类型 **/
  @ApiModelProperty("账户类型")
  @Column(name = "account_type", length = 64, columnDefinition = "VARCHAR(128) COMMENT '账户类型'")
  private String accountType;
  /** userId **/
  @ApiModelProperty("userId")
  @Column(name = "user_id", length = 64, columnDefinition = "VARCHAR(128) COMMENT 'userId'")
  private String userId;
  /** 机构编号 **/
  @ApiModelProperty("机构编号")
  @Column(name = "institution_id", length = 64, columnDefinition = "VARCHAR(128) COMMENT '机构编号'")
  private String institutionId;
  /** 账户安全手机 **/
  @ApiModelProperty("账户安全手机")
  @Column(name = "account_phone_number", length = 64, columnDefinition = "VARCHAR(128) COMMENT '账户安全手机'")
  private String accountPhoneNumber;
  /**
   * 企业信息
   */

  /** 企业名称 **/
  @ApiModelProperty("企业名称")
  @Column(name = "firm_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '企业名称'")
  private String firmName;

  /** 企业简称 **/
  @ApiModelProperty("企业简称")
  @Column(name = "firm_short_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '企业简称'")
  private String firmShortName;

  /** 分类类别 **/
  @ApiModelProperty("分类类别")
  @Column(name = "firm_type", length = 128, columnDefinition = "VARCHAR(128) COMMENT '分类类别'")
  private String firmType;


  /** 企业邮箱 **/
  @ApiModelProperty("企业邮箱")
  @Column(name = "firm_email", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业邮箱'")
  private String firmEmail;

  /** 区域省 **/
  @ApiModelProperty("区域省编码")
  @Column(name = "province_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '区域省编码'")
  private String provinceCode;

  /** 区域市 **/
  @ApiModelProperty("区域市编码")
  @Column(name = "city_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '区域市编码'")
  private String cityCode;

  /** 区域区县 **/
  @ApiModelProperty("区域区县编码")
  @Column(name = "district_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '区域区县编码'")
  private String districtCode;

  /** 区域省名称 **/
  @ApiModelProperty("区域省名称")
  @Column(name = "province_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '区域省名称'")
  private String provinceName;

  /** 区域市名称 **/
  @ApiModelProperty("区域市名称")
  @Column(name = "city_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '区域市名称'")
  private String cityName;

  /** 区域区县名称 **/
  @ApiModelProperty("区域区县名称")
  @Column(name = "district_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '区域区县名称'")
  private String districtName;

  /** 行业 **/
  @ApiModelProperty("行业")
  @Column(name = "industry", length = 64, columnDefinition = "VARCHAR(64) COMMENT '行业'")
  private String industry;

  /** 通用行业 **/
  @ApiModelProperty("通用行业")
  @Column(name = "general_industry", length = 128, columnDefinition = "VARCHAR(128) COMMENT '通用行业'")
  private String generalIndustry;

  /** 企业规模 **/
  @ApiModelProperty("企业规模")
  @Column(name = "scale", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业规模'")
  private String scale;

  /** 企业银行账号 **/
  @ApiModelProperty("企业银行账号")
  @Column(name = "firm_bake_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业银行账号'")
  private String firmBakeNumber;

  /** 开户许可证核准号 **/
  @ApiModelProperty("开户许可证核准号")
  @Column(name = "licence_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '开户许可证核准号'")
  private String licenceNumber;

  /**
   * 证件资料
   */

  /** 营业执照图片地址 **/
  @ApiModelProperty("营业执照图片地址")
  @Column(name = "business_license", length = 128, columnDefinition = "VARCHAR(128) COMMENT '营业执照图片地址'")
  private String  businessLicense;

  /** 统一社会信用代码 **/
  @ApiModelProperty("统一社会信用代码")
  @Column(name = "social_credit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '统一社会信用代码'")
  private String socialCreditCode;

  /** 营业执照有效期起 **/
  @ApiModelProperty("营业执照有效期起")
  @Column(name = "business_license_start_time", columnDefinition = "datetime COMMENT '营业执照有效期起'")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date businessLicenseStartTime;

  /** 营业执照有效期止 **/
  @ApiModelProperty("营业执照有效期止")
  @Column(name = "business_license_end_time", columnDefinition = "datetime COMMENT '营业执照有效期止'")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date businessLicenseEndTime;

  /** 法人身份证正面图片地址 **/
  @ApiModelProperty("法人身份证正面图片地址")
  @Column(name = "legal_card_front", length = 128, columnDefinition = "VARCHAR(128) COMMENT '法人身份证正面图片地址'")
  private String legalCardFront;

  /** 法人身份证背面图片地址 **/
  @ApiModelProperty("法人身份证背面图片地址")
  @Column(name = "legal_card_back", length = 128, columnDefinition = "VARCHAR(128) COMMENT '法人身份证背面图片地址'")
  private String legalCardBack;

  /** 法人姓名 **/
  @ApiModelProperty("法人姓名")
  @Column(name = "legal_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '法人姓名'")
  private String legalName;

  /** 法人身份证号码 **/
  @ApiModelProperty("法人身份证号码")
  @Column(name = "legal_card_number", length = 128, columnDefinition = "VARCHAR(128) COMMENT '法人身份证号码'")
  private String legalCardNumber;

  /** 法人身份证有效期起 **/
  @ApiModelProperty("法人身份证有效期起")
  @Column(name = "legal_card_start_time", columnDefinition = "datetime COMMENT '法人身份证有效期起'")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date legalCardStartTime;

  /** 法人身份证有效期止 **/
  @ApiModelProperty("法人身份证有效期止")
  @Column(name = "legal_card_end_time", columnDefinition = "datetime COMMENT '法人身份证有效期止'")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date legalCardEndTime;

  /** 法人手机号码 **/
  @ApiModelProperty("法人手机号码")
  @Column(name = "legal_phone_number", length = 128, columnDefinition = "VARCHAR(128) COMMENT '法人手机号码'")
  private String legalPhoneNumber;

  /** 法人邮箱 **/
  @ApiModelProperty("法人邮箱")
  @Column(name = "legal_email", length = 64, columnDefinition = "VARCHAR(64) COMMENT '法人邮箱'")
  private String legalEmail;

  /** 签约方式 **/
  @ApiModelProperty("签约方式")
  @Column(name = "contract_way", length = 64, columnDefinition = "VARCHAR(64) COMMENT '签约方式'")
  private String contractWay;

  /** 经办人身份证正面图片地址 **/
  @ApiModelProperty("经办人身份证正面图片地址")
  @Column(name = "agent_card_front", length = 128, columnDefinition = "VARCHAR(128) COMMENT '经办人身份证正面图片地址'")
  private String agentCardFront;

  /** 经办人身份证背面图片地址 **/
  @ApiModelProperty("经办人身份证背面图片地址")
  @Column(name = "agent_card_back", length = 128, columnDefinition = "VARCHAR(128) COMMENT '经办人身份证背面图片地址'")
  private String agentCardBack;

  /** 经办人姓名 **/
  @ApiModelProperty("经办人姓名")
  @Column(name = "agent_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '经办人姓名'")
  private String agentName;

  /** 经办人身份证号码 **/
  @ApiModelProperty("经办人身份证号码")
  @Column(name = "agent_card_number", length = 128, columnDefinition = "VARCHAR(128) COMMENT '经办人身份证号码'")
  private String agentCardNumber;

  /** 经办人身份证有效期起 **/
  @ApiModelProperty("经办人身份证有效期起")
  @Column(name = "agent_card_start_time", columnDefinition = "datetime COMMENT '经办人身份证有效期起'")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date agentCardStartTime;

  /** 经办人身份证有效期止 **/
  @ApiModelProperty("经办人身份证有效期止")
  @Column(name = "agent_card_end_time", columnDefinition = "datetime COMMENT '经办人身份证有效期止'")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date agentCardEndTime;

  /** 经办人手机号码 **/
  @ApiModelProperty("经办人手机号码")
  @Column(name = "agent_phone_number", length = 128, columnDefinition = "VARCHAR(128) COMMENT '经办人手机号码'")
  private String agentPhoneNumber;
}
