package com.biz.crm.common.pay.business.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.pay.business.sdk.service.BankInfoVoService;
import com.biz.crm.common.pay.business.sdk.service.PaymentAccountVoService;
import com.biz.crm.common.pay.business.sdk.vo.BankInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 银行卡信息相关接口
 * @createTime 2022年08月16日 14:57:00
 */
@RestController
@RequestMapping("/v1/pay/bankInfo")
@Slf4j
@Api(tags = "支付模块 ：BankInfoVo ：银行卡")
public class BankInfoVoController {

  @Autowired(required = false)
  private BankInfoVoService bankInfoVoService;

  /**
   * 查询银行卡信息（下拉）
   */
  @ApiOperation(value = "查询银行卡信息（下拉）")
  @GetMapping("getBankCardInfo")
  public Result<List<BankInfoVo>> getBankCardInfo() {
    try {
      List<BankInfoVo> bankCardInfo = bankInfoVoService.getBankCardInfo();
      return Result.ok(bankCardInfo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
