package com.biz.crm.common.pay.business.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import org.apache.ibatis.annotations.Param;

/**
 * 电子账户信息表(MdmPaymentAccount)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2022-08-18 11:15:13
 */
public interface PaymentAccountMapper extends BaseMapper<PaymentAccount> {

  /**
   * 分页查询所有数据
   *
   * @param page              分页对象
   * @param mdmPaymentAccount 查询实体
   * @return 所有数据
   */
  Page<PaymentAccount> findByConditions(@Param("page") Page<PaymentAccount> page, @Param("mdmPaymentAccount") PaymentAccount mdmPaymentAccount);
}

