package com.biz.crm.common.pay.business.local.repository;



import com.biz.crm.common.pay.business.local.entity.PaymentRecord;
import com.biz.crm.common.pay.business.local.mapper.PaymentRecordMapper;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 支付流水表(PaymentRecord)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2022-08-12 14:02:56
 */
@Component
public class PaymentRecordRepository extends ServiceImpl<PaymentRecordMapper, PaymentRecord> {

  @Autowired
  private PaymentRecordMapper paymentRecordMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 实体对象
   * @return
   */
  public Page<PaymentRecord> findByConditions(Pageable pageable, PaymentRecordDto dto) {
    Page<PaymentRecord> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<PaymentRecord> pageList = paymentRecordMapper.findByConditions(page, dto);
    return pageList;
  }

  public void updateStatusByTxSn(String txSn, String status) {
    this.lambdaUpdate()
        .eq(PaymentRecord::getTxSn,txSn)
        .set(PaymentRecord::getStatus,status)
        .update();
  }

  public PaymentRecord findByTxSn(String txSN) {
  return this.lambdaQuery()
      .eq(PaymentRecord::getTxSn,txSN)
      .one();
  }

  public PaymentRecord findByOrderNo(String orderNo) {
    return this.lambdaQuery()
        .eq(PaymentRecord::getTxSn,orderNo)
        .one();
  }

  public void deleteQRMsgByTxSn(String txSN) {
    this.lambdaUpdate()
        .eq(PaymentRecord::getTxSn,txSN)
        .set(PaymentRecord::getQrAuthCode,null)
        .set(PaymentRecord::getQrCodeUrl,null)
        .set(PaymentRecord::getQrImageUrl,null)
        .update();
  }
}

