package com.biz.crm.common.pay.business.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.repository.PaymentAccountRepository;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 电子账户信息表(MdmPaymentAccount)表服务实现类
 *
 * @author HanJiaJun
 * @since 2022-08-18 11:15:12
 */
@Service("mdmPaymentAccountService")
public class PaymentAccountServiceImpl implements PaymentAccountService {

  @Autowired
  private PaymentAccountRepository paymentAccountRepository;

  /**
   * 分页查询数据
   *
   * @param pageable          分页对象
   * @param mdmPaymentAccount 实体对象
   * @return
   */
  @Override
  public Page<PaymentAccount> findByConditions(Pageable pageable, PaymentAccount mdmPaymentAccount) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(mdmPaymentAccount)) {
      mdmPaymentAccount = new PaymentAccount();
    }
    return this.paymentAccountRepository.findByConditions(pageable, mdmPaymentAccount);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public PaymentAccount findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.paymentAccountRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param mdmPaymentAccount 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public PaymentAccount create(PaymentAccount mdmPaymentAccount) {
    this.createValidate(mdmPaymentAccount);
    this.paymentAccountRepository.saveOrUpdate(mdmPaymentAccount);
    return mdmPaymentAccount;
  }

  /**
   * 修改新据
   *
   * @param mdmPaymentAccount 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public PaymentAccount update(PaymentAccount mdmPaymentAccount) {
    this.updateValidate(mdmPaymentAccount);
    this.paymentAccountRepository.saveOrUpdate(mdmPaymentAccount);
    return mdmPaymentAccount;
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.paymentAccountRepository.removeByIds(idList);
  }

  /**
   * 查询开户信息  有且只能有一条记录
   * @return
   */
  @Override
  public PaymentAccount findLocalUserInfo() {
    List<PaymentAccount> byFirmName = this.paymentAccountRepository.findLocalUserInfo();
    if (CollectionUtils.isEmpty(byFirmName)){
      return null;
    }
    Validate.isTrue(byFirmName.size()==1,"开户信息只能在当前系统存在一条记录,请联系管理员");
    return byFirmName.get(0);
  }

  /**
   * 创建验证
   *
   * @param mdmPaymentAccount
   */
  private void createValidate(PaymentAccount mdmPaymentAccount) {
    Validate.notNull(mdmPaymentAccount, "新增时，对象信息不能为空！");
    mdmPaymentAccount.setId(null);
    mdmPaymentAccount.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    mdmPaymentAccount.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    mdmPaymentAccount.setTenantCode(TenantUtils.getTenantCode());
    Validate.notNull(mdmPaymentAccount.getTenantCode(), "新增数据时，租户编号不能为空！");

  }

  /**
   * 修改验证
   *
   * @param mdmPaymentAccount
   */
  private void updateValidate(PaymentAccount mdmPaymentAccount) {
    Validate.notNull(mdmPaymentAccount, "修改时，对象信息不能为空！");
    mdmPaymentAccount.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    mdmPaymentAccount.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    mdmPaymentAccount.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(mdmPaymentAccount.getId(), "修改数据时，ID不能为空！");
    Validate.notBlank(mdmPaymentAccount.getTenantCode(), "修改数据时，租户编号不能为空！");

  }
}

