package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.entity.PaymentAccountBank;
import com.biz.crm.common.pay.business.local.service.PaymentAccountBankService;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.biz.crm.common.pay.business.sdk.dto.PaymentAccountBankDto;
import com.biz.crm.common.pay.business.sdk.dto.PaymentAccountDto;
import com.biz.crm.common.pay.business.sdk.service.PaymentAccountVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountBankVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountExpandVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountVo;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.AccountAuthSupportVoService;
import com.biz.crm.common.pay.support.sdk.service.AccountBalanceSupportVoService;
import com.biz.crm.common.pay.support.sdk.service.PaymentAccountSupportVoService;
import com.biz.crm.common.pay.support.sdk.vo.AccountBalanceSupportVo;
import com.biz.crm.common.pay.support.sdk.vo.PaymentAccountSupportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 付款账户vo 服务impl
 *
 * @author hefan
 * @date 2022/08/09
 */
@Service
public class PaymentAccountVoServiceImpl implements PaymentAccountVoService {

  @Autowired(required = false)
  private PaymentAccountSupportVoService paymentAccountSupportVoService;
  @Autowired(required = false)
  private AccountAuthSupportVoService accountAuthSupportVoService;
  @Autowired
  private PaymentAccountService paymentAccountService;
  @Autowired
  private PaymentAccountBankService paymentAccountBankService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Boolean isAvailable() {
    PaymentAccount localUserInfo = paymentAccountService.findLocalUserInfo();
    Validate.notNull(localUserInfo,"本地尚无开户信息");
    return accountAuthSupportVoService.haveAuthorityToCollectMoney(localUserInfo.getUserId(),null);
  }

  /**
   * 查询用户信息（余额）
   *
   * @return
   */
  @Override
  public PaymentAccountExpandVo findUserInfo() {
    /**
     * 从上下文中取参数
     * UserID        用户ID
     */
    PaymentAccount localUserInfo = paymentAccountService.findLocalUserInfo();
    Validate.notNull(localUserInfo,"本地尚无开户信息");
    PaymentAccountSupportVo byUserId = paymentAccountSupportVoService.findByUserId(localUserInfo.getUserId());
    return  this.nebulaToolkitService.copyObjectByWhiteList(byUserId,PaymentAccountExpandVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 有且只能有一条记录
   * @return
   */
  @Override
  public PaymentAccountVo findLocalUserInfo() {

    PaymentAccount byFirmName = paymentAccountService.findLocalUserInfo();
    if (ObjectUtils.isEmpty(byFirmName)) {
      return null;
    }
    List<PaymentAccountBank> byAccountId = paymentAccountBankService.findByAccountId(byFirmName.getId());
    PaymentAccountVo paymentAccountVo = nebulaToolkitService.copyObjectByWhiteList(byFirmName, PaymentAccountVo.class, HashSet.class, ArrayList.class);
    if (CollectionUtils.isEmpty(byAccountId)) {
      return paymentAccountVo;
    }
    List<PaymentAccountBankVo> paymentAccountBankVos = (List<PaymentAccountBankVo>) nebulaToolkitService.copyCollectionByWhiteList(byAccountId, PaymentAccountBank.class, PaymentAccountBankVo.class, HashSet.class, ArrayList.class);
    paymentAccountVo.setBankList(paymentAccountBankVos);
    return paymentAccountVo;
  }

  /**
   * 手动录入开户信息
   *
   * @param dto
   */
  @Override
  @Transactional
  public void create(PaymentAccountDto dto) {
    Validate.notNull(dto, "手动录入开户信息对象不能为空");
    PaymentAccount byFirmName = paymentAccountService.findLocalUserInfo();
    Validate.isTrue(ObjectUtils.isEmpty(byFirmName),"已存在开户信息");
    PaymentAccount paymentAccount = nebulaToolkitService.copyObjectByWhiteList(dto, PaymentAccount.class, HashSet.class, ArrayList.class);
    paymentAccountService.create(paymentAccount);
    List<PaymentAccountBankDto> bankList = dto.getBankList();
    String id = paymentAccount.getId();
    if (!CollectionUtils.isEmpty(bankList)) {
      List<PaymentAccountBank> paymentAccountBanks = (List<PaymentAccountBank>) nebulaToolkitService.copyCollectionByWhiteList(bankList, PaymentAccountBankDto.class, PaymentAccountBank.class, HashSet.class, ArrayList.class);
      paymentAccountBanks.forEach(e -> {
        e.setAccountId(id);
      });
      paymentAccountBankService.createBrach(paymentAccountBanks);
    }
  }

  /**
   * 更新
   * @param dto
   */
  @Override
  public void update(PaymentAccountDto dto) {
    Validate.notNull(dto, "手动编辑开户信息对象不能为空");
    PaymentAccount paymentAccount = nebulaToolkitService.copyObjectByWhiteList(dto, PaymentAccount.class, HashSet.class, ArrayList.class);
    paymentAccountService.update(paymentAccount);
    List<PaymentAccountBankDto> bankList = dto.getBankList();
    String id = paymentAccount.getId();
    paymentAccountBankService.deleteByAccountId(id);
    if (!CollectionUtils.isEmpty(bankList)) {
      List<PaymentAccountBank> paymentAccountBanks = (List<PaymentAccountBank>) nebulaToolkitService.copyCollectionByWhiteList(bankList, PaymentAccountBankDto.class, PaymentAccountBank.class, HashSet.class, ArrayList.class);
      paymentAccountBanks.forEach(e -> {
        e.setAccountId(id);
      });
      paymentAccountBankService.createBrach(paymentAccountBanks);
    }
  }
}
