package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.biz.crm.common.pay.business.local.service.PaymentSmsVerification;
import com.biz.crm.common.pay.business.sdk.enums.PayOperationType;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.bizunited.nebula.common.service.sms.SmsService;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月29日 09:41:00
 */
@Service
@Slf4j
public class PaymentSmsVerificationImpl implements PaymentSmsVerification {


  @Autowired(required = false)
  private ValiditySmsCodeService validitySmsCodeService;

  @Autowired(required = false)
  private SmsService smsService;
  @Autowired
  private PaymentAccountService paymentAccountService;
  
  /**
   * 发送验证码
   * @param phone
   */
  @Override
  public void sendVerificationCode(String type,String phone) {
    // 检查手机号检查用户有效性
    this.verificationByPhone(type, phone);
    // 校验完毕，发送短信验证码
    String verificationCode = this.generateVerificationCode();
    //保证验证码业务独立性
    verificationCode=verificationCode.concat(type);
    this.validitySmsCodeService.setVerificationCodeValidityPeriod("SMS_136420112", phone, verificationCode);
    String content = "{\"code\":\"" + verificationCode + "\"}";
    this.smsService.sendSms(phone,"SMS_136420112", content, SmsTypeEnums.INFO);
  }

  /**
   * 校验手机号码
   * @param phone
   */
  private void verificationByPhone(String type,String phone) {
    Validate.notBlank(phone,"手机号不能为空!");
    PaymentAccount localUserInfo = paymentAccountService.findLocalUserInfo();
    Validate.notNull(localUserInfo,"暂无开户信息");
    String accountPhoneNumber = localUserInfo.getAccountPhoneNumber();
    Validate.isTrue(phone.equals(accountPhoneNumber),"当前手机号与开户信息安全手机号不符!");
    Validate.notBlank(type,"支付操作类型不能为空");
    PayOperationType enumByDictCode = PayOperationType.getEnumByDictCode(type);
    Validate.notNull(enumByDictCode,"未知的支付操作类型");
  }
}
