package com.biz.crm.common.pay.business.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author HanJiaJun
 * @describe: 电子账户绑定银行卡信息
 * @createTime 2022年08月17日 17:32:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PaymentAccountBank", description = "电子账户绑定银行卡信息")
@Entity
@TableName("mdm_payment_account_bank")
@Table(
    name = "mdm_payment_account_bank")
@org.hibernate.annotations.Table(appliesTo = "mdm_payment_account_bank", comment = "电子账户绑定银行卡信息")
public class PaymentAccountBank  extends TenantFlagOpEntity {


  /** 电子账户ID **/
  @ApiModelProperty("电子账户ID")
  @Column(name = "account_id", length = 64, columnDefinition = "VARCHAR2(128)")
  private String accountId;

  /** 身份证号码 **/
  @ApiModelProperty("身份证号码")
  @Column(name = "card_number", length = 128, columnDefinition = "VARCHAR2(128)")
  private String cardNumber;


  /** 开户银行ID **/
  @ApiModelProperty("开户银行ID")
  @Column(name = "bank_id", length = 128, columnDefinition = "VARCHAR2(128)")
  private String bankId;

  /** 开户银行名称 **/
  @ApiModelProperty("开户银行名称")
  @Column(name = "bank_name", length = 128, columnDefinition = "VARCHAR2(128)")
  private String bankName;

  /** 开户银行账户名称 **/
  @ApiModelProperty("开户银行账户名称")
  @Column(name = "bank_account_name", length = 128, columnDefinition = "VARCHAR2(128)")
  private String bankAccountName;

  /** 银行卡号 **/
  @ApiModelProperty("银行卡号")
  @Column(name = "bank_number", length = 128, columnDefinition = "VARCHAR2(128)")
  private String bankNumber;

  /** 手机号码 **/
  @ApiModelProperty("手机号码")
  @Column(name = "phone_number", length = 16, columnDefinition = "VARCHAR2(16)")
  private String phoneNumber;

  /** 人民银行联行号 **/
  @ApiModelProperty("人民银行联行号")
  @Column(name = "lines_number", length = 64, columnDefinition = "VARCHAR2(64)")
  private String linesNumber;

  /** 分支行名称 **/
  @ApiModelProperty("分支行名称")
  @Column(name = "bank_branch_name", length = 128, columnDefinition = "VARCHAR2(128)")
  private String bankBranchName;

  /** 开户行所在区域 **/
  @ApiModelProperty("开户行所在区域")
  @Column(name = "bank_area", length = 128, columnDefinition = "VARCHAR2(128)")
  private String bankArea;
}
