package com.biz.crm.common.pay.business.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe: 支付流水记录实体
 * @createTime 2022年08月11日 16:33:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PaymentRecord", description = "支付流水表")
@Entity
@TableName("mdm_payment_record")
@Table(name = "mdm_payment_record", indexes = {
        @Index(name = "mdm_payment_r_index1", columnList = "customer_code,tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_payment_record", comment = "支付流水表")
public class PaymentRecord extends TenantFlagOpEntity {


    private static final long serialVersionUID = -7067734225734344347L;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR2(64)")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR2(64)")
    private String customerName;

    /**
     * 操作类型
     */
    @ApiModelProperty("操作类型")
    @Column(name = "operation_type", length = 64, columnDefinition = "VARCHAR2(64)")
    private String operationType;

    /**
     * 关联单据号
     */
    @ApiModelProperty("关联单据号")
    @Column(name = "relationship_doc_number", length = 64, columnDefinition = "VARCHAR2(64)")
    private String relationshipDocNumber;

    /**
     * 金额
     */
    @ApiModelProperty("金额")
    @Column(name = "amount", length = 20, columnDefinition = "NUMBER(20,4)")
    private BigDecimal amount;

    /**
     * 操作时间
     */
    @ApiModelProperty("操作时间")
    @Column(name = "operation_time", columnDefinition = "DATE")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date operationTime;

    /**
     * 流水交易号
     */
    @ApiModelProperty("流水交易号")
    @Column(name = "txSn", length = 128, columnDefinition = "VARCHAR2(128)")
    private String txSn;

    /**
     * 交易状态
     */
    @ApiModelProperty("交易状态")
    @Column(name = "status", length = 64, columnDefinition = "VARCHAR2(64)")
    private String status;

    /**
     * 支付宝微信聚合码二维码
     */
    @ApiModelProperty("支付宝微信聚合码二维码")
    @Column(name = "qr_code_url", length = 256, columnDefinition = "VARCHAR2(256)")
    private String qrCodeUrl;

    /**
     * 支付宝微信聚合码二维码图片URL
     */
    @ApiModelProperty("支付宝微信聚合码二维码图片URL")
    @Column(name = "qr_image_url", length = 256, columnDefinition = "VARCHAR2(256)")
    private String qrImageUrl;


    /**
     * 授权码  跳转支付
     */
    @ApiModelProperty("授权码(跳转支付)")
    @Column(name = "qr_auth_code", length = 256, columnDefinition = "VARCHAR2(256)")
    private String qrAuthCode;
}
