package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.biz.crm.common.pay.business.sdk.service.BankInfoVoService;
import com.biz.crm.common.pay.business.sdk.vo.BankInfoVo;
import com.biz.crm.common.pay.support.sdk.service.BankAccountSupportVoService;
import com.biz.crm.common.pay.support.sdk.vo.BankAccountSupportVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月16日 15:06:00
 */
@Service
public class BankInfoVoServiceImpl implements BankInfoVoService {

  @Autowired(required = false)
  private BankAccountSupportVoService bankAccountSupportVoService;
  @Autowired
  private PaymentAccountService paymentAccountService;

  @Override
  public List<BankInfoVo> getBankCardInfo() {
    /**
     * 从上下文中取参数
     * InstitutionID 机构编码
     * MainUserID    主用户ID
     * UserID        用户ID
     * 注：用户ID与主用户ID不能同时为空
     */
    PaymentAccount localUserInfo = paymentAccountService.findLocalUserInfo();
    List<BankInfoVo> resList = new ArrayList<>();
    Collection<BankAccountSupportVo> response = bankAccountSupportVoService.findAll(null, localUserInfo.getUserId());
    Validate.isTrue(!CollectionUtils.isEmpty(response), "无银行卡查询结果");
    Validate.notEmpty(response, "无银行卡查询结果");
    for (BankAccountSupportVo bankAccountSupportVo : response) {
      BankInfoVo vo = new BankInfoVo();
      vo.setAccountName(bankAccountSupportVo.getBankAccountName());
      vo.setBankID(bankAccountSupportVo.getBankID());
      vo.setBankCardNumber(bankAccountSupportVo.getBankAccountNumber());
      vo.setBindingTxSN(bankAccountSupportVo.getBindingTxSN());
      resList.add(vo);
    }
    return resList;
  }
}
