package com.biz.crm.common.pay.business.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.pay.business.sdk.dto.PayBusinessDto;
import com.biz.crm.common.pay.business.sdk.dto.WithdrawalDto;
import com.biz.crm.common.pay.business.sdk.service.PaymentOperationVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentOperationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HanJiaJun
 * @describe: 支付操作服务接口（提现，支付，转账）
 * @createTime 2022年08月16日 15:10:00
 */
@RestController
@RequestMapping("/v1/pay/operation")
@Slf4j
@Api(tags = "支付模块 ：PaymentOperation ：支付操作")
public class PaymentOperationVoController {

  @Autowired
  private PaymentOperationVoService paymentOperationService;

  /**
   * 提现
   * @return
   */
  @ApiOperation(value = "提现")
  @PostMapping("withdrawal")
  public Result withdrawal(@RequestBody WithdrawalDto dto) {
    try {
      String result = paymentOperationService.withdrawal(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 充值
   * @return
   */
  @ApiOperation(value = "充值")
  @PostMapping("recharge")
  public Result<PaymentOperationVo> recharge(@RequestBody PayBusinessDto dto) {
    try {
      PaymentOperationVo vo = paymentOperationService.recharge(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 支付
   * @return
   */
  @ApiOperation(value = "支付")
  @PostMapping("pay")
  public Result<PaymentOperationVo> pay(@RequestBody PayBusinessDto dto) {
    try {
      PaymentOperationVo vo =  paymentOperationService.pay(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
