package com.biz.crm.common.pay.business.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.pay.business.local.entity.PaymentRecord;
import com.biz.crm.common.pay.business.local.service.PaymentRecordService;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 支付流水表(PaymentRecord)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2022-08-12 14:02:56
 */
@RestController
@RequestMapping("/v1/paymentRecord/paymentRecord")
@Slf4j
@Api(tags = "支付流水表")
public class PaymentRecordController {
  /**
   * 服务对象
   */
  @Autowired
  private PaymentRecordService PaymentRecordService;

  /**
   * 分页查询所有数据
   *
   * @param pageable      分页对象
   * @param dto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<PaymentRecord>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "PaymentRecord", value = "支付流水表") PaymentRecordDto dto) {
    try {
      Page<PaymentRecord> page = this.PaymentRecordService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<PaymentRecord> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      PaymentRecord PaymentRecord = this.PaymentRecordService.findById(id);
      return Result.ok(PaymentRecord);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param paymentRecord 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<PaymentRecord> create(@ApiParam(name = "PaymentRecord", value = "支付流水表") @RequestBody PaymentRecord paymentRecord) {
    try {
      PaymentRecord result = this.PaymentRecordService.create(paymentRecord);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param paymentRecord 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<PaymentRecord> update(@ApiParam(name = "PaymentRecord", value = "支付流水表") @RequestBody PaymentRecord paymentRecord) {
    try {
      PaymentRecord result = this.PaymentRecordService.update(paymentRecord);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.PaymentRecordService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
