/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.pay.business.local.entity.PaymentRecord;
import com.biz.crm.common.pay.business.local.repository.PaymentRecordRepository;
import com.biz.crm.common.pay.business.local.service.PaymentRecordService;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import com.biz.crm.common.pay.business.sdk.enums.PayStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="PaymentRecordService")
public class PaymentRecordServiceImpl
implements PaymentRecordService {
    private static final Logger log = LoggerFactory.getLogger(PaymentRecordServiceImpl.class);
    @Autowired
    private PaymentRecordRepository paymentRecordRepository;

    @Override
    public Page<PaymentRecord> findByConditions(Pageable pageable, PaymentRecordDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new PaymentRecordDto();
        }
        return this.paymentRecordRepository.findByConditions(pageable, dto);
    }

    @Override
    public PaymentRecord findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (PaymentRecord)((Object)this.paymentRecordRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public PaymentRecord create(PaymentRecord paymentRecord) {
        this.createValidate(paymentRecord);
        this.paymentRecordRepository.saveOrUpdate((Object)paymentRecord);
        return paymentRecord;
    }

    @Override
    @Transactional
    public PaymentRecord update(PaymentRecord paymentRecord) {
        this.updateValidate(paymentRecord);
        this.paymentRecordRepository.saveOrUpdate((Object)paymentRecord);
        return paymentRecord;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.paymentRecordRepository.removeByIds(idList);
    }

    @Override
    public void updateStatusByTxSn(String txSn, String status) {
        Validate.notBlank((CharSequence)txSn, (String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)status, (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.paymentRecordRepository.updateStatusByTxSn(txSn, status);
    }

    @Override
    public PaymentRecord findByTxSn(String txSN) {
        if (StringUtils.isBlank((CharSequence)txSN)) {
            return null;
        }
        return this.paymentRecordRepository.findByTxSn(txSN);
    }

    @Override
    public PaymentRecord findByOrderNo(String orderNo) {
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return null;
        }
        return this.paymentRecordRepository.findByOrderNo(orderNo);
    }

    @Override
    public void deleteQRMsgByTxSn(String txSN) {
        Validate.notBlank((CharSequence)txSN, (String)"\u5220\u9664QR\u4fe1\u606f\u65f6\uff0c\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PaymentRecord byTxSn = this.paymentRecordRepository.findByTxSn(txSN);
        Validate.notNull((Object)((Object)byTxSn), (String)"\u5220\u9664QR\u4fe1\u606f\u65f6,\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6d41\u6c34\u8bb0\u5f55", (Object[])new Object[0]);
        this.paymentRecordRepository.deleteQRMsgByTxSn(txSN);
    }

    private void createValidate(PaymentRecord paymentRecord) {
        Validate.notNull((Object)((Object)paymentRecord), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        paymentRecord.setId(null);
        paymentRecord.setTenantCode(TenantUtils.getTenantCode());
        paymentRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        paymentRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        paymentRecord.setStatus(PayStatusEnum.PROCESSING.getDictCode());
        Validate.notBlank((CharSequence)paymentRecord.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)paymentRecord.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)paymentRecord.getOperationTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getOperationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getRelationshipDocNumber(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(PaymentRecord paymentRecord) {
        Validate.notNull((Object)((Object)paymentRecord), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)paymentRecord.getAmount(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getCustomerCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)paymentRecord.getOperationTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getOperationType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paymentRecord.getRelationshipDocNumber(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5173\u8054\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

