/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.biz.crm.common.pay.business.local.service.PaymentSmsVerification;
import com.biz.crm.common.pay.business.sdk.enums.PayOperationType;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.bizunited.nebula.common.service.sms.SmsService;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentSmsVerificationImpl
implements PaymentSmsVerification {
    private static final Logger log = LoggerFactory.getLogger(PaymentSmsVerificationImpl.class);
    @Autowired(required=false)
    private ValiditySmsCodeService validitySmsCodeService;
    @Autowired(required=false)
    private SmsService smsService;
    @Autowired
    private PaymentAccountService paymentAccountService;

    @Override
    public void sendVerificationCode(String type, String phone) {
        this.verificationByPhone(type, phone);
        String verificationCode = this.generateVerificationCode();
        verificationCode = verificationCode.concat(type);
        this.validitySmsCodeService.setVerificationCodeValidityPeriod("SMS_136420112", phone, verificationCode);
        String content = "{\"code\":\"" + verificationCode + "\"}";
        this.smsService.sendSms(phone, "SMS_136420112", content, SmsTypeEnums.INFO);
    }

    private void verificationByPhone(String type, String phone) {
        Validate.notBlank((CharSequence)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        PaymentAccount localUserInfo = this.paymentAccountService.findLocalUserInfo();
        Validate.notNull((Object)((Object)localUserInfo), (String)"\u6682\u65e0\u5f00\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String accountPhoneNumber = localUserInfo.getAccountPhoneNumber();
        Validate.isTrue((boolean)phone.equals(accountPhoneNumber), (String)"\u5f53\u524d\u624b\u673a\u53f7\u4e0e\u5f00\u6237\u4fe1\u606f\u5b89\u5168\u624b\u673a\u53f7\u4e0d\u7b26!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)type, (String)"\u652f\u4ed8\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PayOperationType enumByDictCode = PayOperationType.getEnumByDictCode((String)type);
        Validate.notNull((Object)enumByDictCode, (String)"\u672a\u77e5\u7684\u652f\u4ed8\u64cd\u4f5c\u7c7b\u578b", (Object[])new Object[0]);
    }
}

