package com.biz.crm.common.pay.business.local.service.internal;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.pay.business.local.entity.PaymentAccountBank;
import com.biz.crm.common.pay.business.local.repository.PaymentAccountBankRepository;
import com.biz.crm.common.pay.business.local.service.PaymentAccountBankService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.persistence.Id;
import java.util.ArrayList;
import java.util.List;

/**
 * 电子账户绑定银行卡信息(MdmPaymentAccountBank)表服务实现类
 *
 * @author HanJiaJun
 * @since 2022-08-18 11:42:20
 */
@Service("mdmPaymentAccountBankService")
public class PaymentAccountBankServiceImpl implements PaymentAccountBankService {

  @Autowired
  PaymentAccountBankRepository paymentAccountBankRepository;
  
  /**
   * 新增数据
   * @param mdmPaymentAccountBank 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public PaymentAccountBank create(PaymentAccountBank mdmPaymentAccountBank) {
    this.createValidate(mdmPaymentAccountBank);
    this.paymentAccountBankRepository.saveOrUpdate(mdmPaymentAccountBank);
    return mdmPaymentAccountBank;
  }

  @Override
  public void createBrach(List<PaymentAccountBank> mdmPaymentAccountBank) {
    Validate.notEmpty(mdmPaymentAccountBank,"创建时，数据集合不能为空!");
    for (PaymentAccountBank paymentAccountBank : mdmPaymentAccountBank) {
      this.createValidate(paymentAccountBank);
    }
    this.paymentAccountBankRepository.saveBatch(mdmPaymentAccountBank);
  }

  /**
   * 修改新据
   * @param mdmPaymentAccountBank 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public PaymentAccountBank update(PaymentAccountBank mdmPaymentAccountBank) {
    this.updateValidate(mdmPaymentAccountBank);
    this.paymentAccountBankRepository.saveOrUpdate(mdmPaymentAccountBank);
    return mdmPaymentAccountBank;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.paymentAccountBankRepository.removeByIds(idList);
  }

  @Override
  public void deleteByAccountId(String accountId) {
    Validate.notBlank(accountId,"删除绑定卡信息时，账户ID不能为空");
    this.paymentAccountBankRepository.deleteByAccountId(accountId);
  }

  @Override
  public List<PaymentAccountBank> findByAccountId(String accountId) {
    if (StringUtils.isBlank(accountId)){
      return new ArrayList<>(0);
    }
    return this.paymentAccountBankRepository.findByAccountId(accountId);
  }

  /**
   * 创建验证
   * @param mdmPaymentAccountBank
   */
  private void createValidate(PaymentAccountBank mdmPaymentAccountBank) {
    Validate.notNull(mdmPaymentAccountBank, "新增时，对象信息不能为空！");
	  mdmPaymentAccountBank.setId(null);
    mdmPaymentAccountBank.setTenantCode(TenantUtils.getTenantCode());
    mdmPaymentAccountBank.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    mdmPaymentAccountBank.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Validate.notNull(mdmPaymentAccountBank.getTenantCode(), "新增数据时，租户编号不能为空！");
     
  }
  
   /**
   * 修改验证
   * @param mdmPaymentAccountBank
   */
  private void updateValidate(PaymentAccountBank mdmPaymentAccountBank) {
    Validate.notNull(mdmPaymentAccountBank, "修改时，对象信息不能为空！");
    Validate.notBlank(mdmPaymentAccountBank.getId(), "修改数据时，id不能为空！");
    Validate.notBlank(mdmPaymentAccountBank.getTenantCode(), "修改数据时，租户编号不能为空！");
      
  }
}

